/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;

public class RoleUtils {
    public static boolean inGuild(Guild guild, OfflinePlayer offlinePlayer) {
        return guild.getMember(offlinePlayer.getUniqueId()) != null;
    }

    public static boolean canPromote(Guild guild, OfflinePlayer offlinePlayer) {
        return guild.getMember(offlinePlayer.getUniqueId()).getRole().getLevel() >= 1;
    }

    public static boolean isOfficer(Guild guild, OfflinePlayer offlinePlayer) {
        return guild.getMember(offlinePlayer.getUniqueId()).getRole().getLevel() == 1;
    }

    public static boolean checkPromote(Guild guild, OfflinePlayer offlinePlayer, OfflinePlayer offlinePlayer2) {
        return guild.getMember(offlinePlayer.getUniqueId()).getRole().getLevel() - 1 == guild.getMember(offlinePlayer2.getUniqueId()).getRole().getLevel();
    }

    public static boolean sameRole(Guild guild, OfflinePlayer offlinePlayer, OfflinePlayer offlinePlayer2) {
        return guild.getMember(offlinePlayer.getUniqueId()).getRole().getLevel() == guild.getMember(offlinePlayer2.getUniqueId()).getRole().getLevel();
    }

    public static void promote(GuildHandler guildHandler, Guild guild, OfflinePlayer offlinePlayer) {
        Permission permission = guildHandler.getGuildsPlugin().getPermissions();
        GuildMember guildMember = guild.getMember(offlinePlayer.getUniqueId());
        guildHandler.removeRolePerm(permission, offlinePlayer);
        guildMember.setRole(guildHandler.getGuildRole(guildMember.getRole().getLevel() - 1));
        guildHandler.addRolePerm(permission, offlinePlayer);
    }

    public static void demote(GuildHandler guildHandler, Guild guild, OfflinePlayer offlinePlayer) {
        Permission permission = guildHandler.getGuildsPlugin().getPermissions();
        GuildMember guildMember = guild.getMember(offlinePlayer.getUniqueId());
        guildHandler.removeRolePerm(permission, offlinePlayer);
        guildMember.setRole(guildHandler.getGuildRole(guildMember.getRole().getLevel() + 1));
        guildHandler.addRolePerm(permission, offlinePlayer);
    }

    public static String getCurrentRoleName(GuildMember guildMember) {
        return guildMember.getRole().getName();
    }

    public static String getPrePromotedRoleName(GuildHandler guildHandler, GuildMember guildMember) {
        return guildHandler.getGuildRole(guildMember.getRole().getLevel() + 1).getName();
    }

    public static String getPreDemotedRoleName(GuildHandler guildHandler, GuildMember guildMember) {
        return guildHandler.getGuildRole(guildMember.getRole().getLevel() - 1).getName();
    }

    public static boolean isLowest(GuildHandler guildHandler, GuildMember guildMember) {
        return guildHandler.getLowestGuildRole().getLevel() == guildMember.getRole().getLevel();
    }

    public static boolean isLower(GuildMember guildMember, GuildMember guildMember2) {
        return guildMember.getRole().getLevel() < guildMember2.getRole().getLevel();
    }
}

