/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends HashMap<String, Object>
implements JSONAware,
JSONAwareEx,
JSONStreamAwareEx {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public static String escape(String string) {
        return JSONValue.escape(string);
    }

    public static String toJSONString(Map<String, ? extends Object> map) {
        return JSONObject.toJSONString(map, JSONValue.COMPRESSION);
    }

    public static String toJSONString(Map<String, ? extends Object> map, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONObject.writeJSON(map, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static void writeJSONKV(String string, Object object, Appendable appendable, JSONStyle jSONStyle) {
        if (string == null) {
            appendable.append("null");
        } else if (!jSONStyle.mustProtectKey(string)) {
            appendable.append(string);
        } else {
            appendable.append('\"');
            JSONValue.escape(string, appendable, jSONStyle);
            appendable.append('\"');
        }
        appendable.append(':');
        if (object instanceof String) {
            if (!jSONStyle.mustProtectValue((String)object)) {
                appendable.append((String)object);
            } else {
                appendable.append('\"');
                JSONValue.escape((String)object, appendable, jSONStyle);
                appendable.append('\"');
            }
        } else {
            JSONValue.writeJSONString(object, appendable, jSONStyle);
        }
    }

    public JSONObject(Map<String, ?> map) {
        super(map);
    }

    public static void writeJSON(Map<String, Object> map, Appendable appendable) {
        JSONObject.writeJSON(map, appendable, JSONValue.COMPRESSION);
    }

    public static void writeJSON(Map<String, ? extends Object> map, Appendable appendable, JSONStyle jSONStyle) {
        if (map == null) {
            appendable.append("null");
            return;
        }
        boolean bl = true;
        appendable.append('{');
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(',');
            }
            JSONObject.writeJSONKV(entry.getKey().toString(), entry.getValue(), appendable, jSONStyle);
        }
        appendable.append('}');
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        JSONObject.writeJSON(this, appendable, JSONValue.COMPRESSION);
    }

    @Override
    public void writeJSONString(Appendable appendable, JSONStyle jSONStyle) {
        JSONObject.writeJSON(this, appendable, jSONStyle);
    }

    public void merge(Object object) {
        JSONObject.merge(this, object);
    }

    protected static JSONObject merge(JSONObject jSONObject, Object object) {
        if (object == null) {
            return jSONObject;
        }
        if (object instanceof JSONObject) {
            return JSONObject.merge(jSONObject, (JSONObject)object);
        }
        throw new RuntimeException("JSON megre can not merge JSONObject with " + object.getClass());
    }

    private static JSONObject merge(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 == null) {
            return jSONObject;
        }
        for (String string : jSONObject.keySet()) {
            Object v = jSONObject.get(string);
            Object v2 = jSONObject2.get(string);
            if (v2 == null) continue;
            if (v instanceof JSONArray) {
                jSONObject.put(string, JSONObject.merge((JSONArray)v, v2));
                continue;
            }
            if (v instanceof JSONObject) {
                jSONObject.put(string, JSONObject.merge((JSONObject)v, v2));
                continue;
            }
            if (v.equals(v2)) continue;
            throw new RuntimeException("JSON megre can not merge " + v.getClass() + " with " + v2.getClass());
        }
        for (String string : jSONObject2.keySet()) {
            if (jSONObject.containsKey(string)) continue;
            jSONObject.put(string, jSONObject2.get(string));
        }
        return jSONObject;
    }

    protected static JSONArray merge(JSONArray jSONArray, Object object) {
        if (object == null) {
            return jSONArray;
        }
        if (jSONArray instanceof JSONArray) {
            return JSONObject.merge(jSONArray, (JSONArray)object);
        }
        jSONArray.add(object);
        return jSONArray;
    }

    private static JSONArray merge(JSONArray jSONArray, JSONArray jSONArray2) {
        jSONArray.addAll(jSONArray2);
        return jSONArray;
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }

    @Override
    public String toJSONString(JSONStyle jSONStyle) {
        return JSONObject.toJSONString(this, jSONStyle);
    }

    public String toString(JSONStyle jSONStyle) {
        return JSONObject.toJSONString(this, jSONStyle);
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this, JSONValue.COMPRESSION);
    }
}

