/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;

public class ANTLRInputStream
implements CharStream {
    public static final int READ_BUFFER_SIZE = 1024;
    public static final int INITIAL_BUFFER_SIZE = 1024;
    protected char[] data;
    protected int n;
    protected int p = 0;
    public String name;

    public ANTLRInputStream() {
    }

    public ANTLRInputStream(String string) {
        this.data = string.toCharArray();
        this.n = string.length();
    }

    public ANTLRInputStream(char[] cArray, int n) {
        this.data = cArray;
        this.n = n;
    }

    public ANTLRInputStream(Reader reader) {
        this(reader, 1024, 1024);
    }

    public ANTLRInputStream(Reader reader, int n) {
        this(reader, n, 1024);
    }

    public ANTLRInputStream(Reader reader, int n, int n2) {
        this.load(reader, n, n2);
    }

    public ANTLRInputStream(InputStream inputStream) {
        this(new InputStreamReader(inputStream), 1024);
    }

    public ANTLRInputStream(InputStream inputStream, int n) {
        this(new InputStreamReader(inputStream), n);
    }

    public ANTLRInputStream(InputStream inputStream, int n, int n2) {
        this(new InputStreamReader(inputStream), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader, int n, int n2) {
        if (reader == null) {
            return;
        }
        if (n <= 0) {
            n = 1024;
        }
        if (n2 <= 0) {
            n2 = 1024;
        }
        try {
            this.data = new char[n];
            int n3 = 0;
            int n4 = 0;
            do {
                if (n4 + n2 > this.data.length) {
                    this.data = Arrays.copyOf(this.data, this.data.length * 2);
                }
                n3 = reader.read(this.data, n4, n2);
                n4 += n3;
            } while (n3 != -1);
            this.n = n4 + 1;
        }
        finally {
            reader.close();
        }
    }

    public void reset() {
        this.p = 0;
    }

    @Override
    public void consume() {
        if (this.p >= this.n) {
            assert (this.LA(1) == -1);
            throw new IllegalStateException("cannot consume EOF");
        }
        if (this.p < this.n) {
            ++this.p;
        }
    }

    @Override
    public int LA(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0 && this.p + ++n - 1 < 0) {
            return -1;
        }
        if (this.p + n - 1 >= this.n) {
            return -1;
        }
        return this.data[this.p + n - 1];
    }

    public int LT(int n) {
        return this.LA(n);
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int mark() {
        return -1;
    }

    @Override
    public void release(int n) {
    }

    @Override
    public void seek(int n) {
        if (n <= this.p) {
            this.p = n;
            return;
        }
        n = Math.min(n, this.n);
        while (this.p < n) {
            this.consume();
        }
    }

    @Override
    public String getText(Interval interval) {
        int n = interval.a;
        int n2 = interval.b;
        if (n2 >= this.n) {
            n2 = this.n - 1;
        }
        int n3 = n2 - n + 1;
        if (n >= this.n) {
            return "";
        }
        return new String(this.data, n, n3);
    }

    @Override
    public String getSourceName() {
        if (this.name == null || this.name.isEmpty()) {
            return "<unknown>";
        }
        return this.name;
    }

    public String toString() {
        return new String(this.data);
    }
}

