/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;

public final class CharStreams {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private CharStreams() {
    }

    public static CharStream fromPath(Path path) {
        return CharStreams.fromPath(path, StandardCharsets.UTF_8);
    }

    public static CharStream fromPath(Path path, Charset charset) {
        long l = Files.size(path);
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);){
            CodePointCharStream codePointCharStream = CharStreams.fromChannel(seekableByteChannel, charset, 4096, CodingErrorAction.REPLACE, path.toString(), l);
            return codePointCharStream;
        }
    }

    public static CharStream fromFileName(String string) {
        return CharStreams.fromPath(Paths.get(string, new String[0]), StandardCharsets.UTF_8);
    }

    public static CharStream fromFileName(String string, Charset charset) {
        return CharStreams.fromPath(Paths.get(string, new String[0]), charset);
    }

    public static CharStream fromStream(InputStream inputStream) {
        return CharStreams.fromStream(inputStream, StandardCharsets.UTF_8);
    }

    public static CharStream fromStream(InputStream inputStream, Charset charset) {
        return CharStreams.fromStream(inputStream, charset, -1L);
    }

    public static CharStream fromStream(InputStream inputStream, Charset charset, long l) {
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);){
            CodePointCharStream codePointCharStream = CharStreams.fromChannel(readableByteChannel, charset, 4096, CodingErrorAction.REPLACE, "<unknown>", l);
            return codePointCharStream;
        }
    }

    public static CharStream fromChannel(ReadableByteChannel readableByteChannel) {
        return CharStreams.fromChannel(readableByteChannel, StandardCharsets.UTF_8);
    }

    public static CharStream fromChannel(ReadableByteChannel readableByteChannel, Charset charset) {
        return CharStreams.fromChannel(readableByteChannel, 4096, CodingErrorAction.REPLACE, "<unknown>");
    }

    public static CodePointCharStream fromReader(Reader reader) {
        return CharStreams.fromReader(reader, "<unknown>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodePointCharStream fromReader(Reader reader, String string) {
        try {
            CodePointBuffer.Builder builder = CodePointBuffer.builder(4096);
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while (reader.read(charBuffer) != -1) {
                charBuffer.flip();
                builder.append(charBuffer);
                charBuffer.compact();
            }
            CodePointCharStream codePointCharStream = CodePointCharStream.fromBuffer(builder.build(), string);
            return codePointCharStream;
        }
        finally {
            reader.close();
        }
    }

    public static CodePointCharStream fromString(String string) {
        return CharStreams.fromString(string, "<unknown>");
    }

    public static CodePointCharStream fromString(String string, String string2) {
        CodePointBuffer.Builder builder = CodePointBuffer.builder(string.length());
        CharBuffer charBuffer = CharBuffer.allocate(string.length());
        charBuffer.put(string);
        charBuffer.flip();
        builder.append(charBuffer);
        return CodePointCharStream.fromBuffer(builder.build(), string2);
    }

    public static CodePointCharStream fromChannel(ReadableByteChannel readableByteChannel, int n, CodingErrorAction codingErrorAction, String string) {
        return CharStreams.fromChannel(readableByteChannel, StandardCharsets.UTF_8, n, codingErrorAction, string, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodePointCharStream fromChannel(ReadableByteChannel readableByteChannel, Charset charset, int n, CodingErrorAction codingErrorAction, String string, long l) {
        try {
            Object object;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            CharBuffer charBuffer = CharBuffer.allocate(n);
            if (l == -1L) {
                l = n;
            } else if (l > Integer.MAX_VALUE) {
                throw new IOException(String.format("inputSize %d larger than max %d", l, Integer.MAX_VALUE));
            }
            CodePointBuffer.Builder builder = CodePointBuffer.builder((int)l);
            CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
            boolean bl = false;
            while (!bl) {
                int n2 = readableByteChannel.read(byteBuffer);
                bl = n2 == -1;
                byteBuffer.flip();
                object = charsetDecoder.decode(byteBuffer, charBuffer, bl);
                if (((CoderResult)object).isError() && codingErrorAction.equals(CodingErrorAction.REPORT)) {
                    ((CoderResult)object).throwException();
                }
                charBuffer.flip();
                builder.append(charBuffer);
                byteBuffer.compact();
                charBuffer.compact();
            }
            CoderResult coderResult = charsetDecoder.flush(charBuffer);
            if (coderResult.isError() && codingErrorAction.equals(CodingErrorAction.REPORT)) {
                coderResult.throwException();
            }
            charBuffer.flip();
            builder.append(charBuffer);
            object = builder.build();
            CodePointCharStream codePointCharStream = CodePointCharStream.fromBuffer((CodePointBuffer)object, string);
            return codePointCharStream;
        }
        finally {
            readableByteChannel.close();
        }
    }
}

