/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.Pair;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;
    protected ParserRuleContext nextTokensContext;
    protected int nextTokensState;

    @Override
    public void reset(Parser parser) {
        this.endErrorCondition(parser);
    }

    protected void beginErrorCondition(Parser parser) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser parser) {
        return this.errorRecoveryMode;
    }

    protected void endErrorCondition(Parser parser) {
        this.errorRecoveryMode = false;
        this.lastErrorStates = null;
        this.lastErrorIndex = -1;
    }

    @Override
    public void reportMatch(Parser parser) {
        this.endErrorCondition(parser);
    }

    @Override
    public void reportError(Parser parser, RecognitionException recognitionException) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        if (recognitionException instanceof NoViableAltException) {
            this.reportNoViableAlternative(parser, (NoViableAltException)recognitionException);
        } else if (recognitionException instanceof InputMismatchException) {
            this.reportInputMismatch(parser, (InputMismatchException)recognitionException);
        } else if (recognitionException instanceof FailedPredicateException) {
            this.reportFailedPredicate(parser, (FailedPredicateException)recognitionException);
        } else {
            System.err.println("unknown recognition error type: " + recognitionException.getClass().getName());
            parser.notifyErrorListeners(recognitionException.getOffendingToken(), recognitionException.getMessage(), recognitionException);
        }
    }

    @Override
    public void recover(Parser parser, RecognitionException recognitionException) {
        if (this.lastErrorIndex == parser.getInputStream().index() && this.lastErrorStates != null && this.lastErrorStates.contains(parser.getState())) {
            parser.consume();
        }
        this.lastErrorIndex = parser.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet(new int[0]);
        }
        this.lastErrorStates.add(parser.getState());
        IntervalSet intervalSet = this.getErrorRecoverySet(parser);
        this.consumeUntil(parser, intervalSet);
    }

    @Override
    public void sync(Parser parser) {
        ATNState aTNState = ((ParserATNSimulator)parser.getInterpreter()).atn.states.get(parser.getState());
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        TokenStream tokenStream = parser.getInputStream();
        int n = tokenStream.LA(1);
        IntervalSet intervalSet = parser.getATN().nextTokens(aTNState);
        if (intervalSet.contains(n)) {
            this.nextTokensContext = null;
            this.nextTokensState = -1;
            return;
        }
        if (intervalSet.contains(-2)) {
            if (this.nextTokensContext == null) {
                this.nextTokensContext = parser.getContext();
                this.nextTokensState = parser.getState();
            }
            return;
        }
        switch (aTNState.getStateType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(parser) != null) {
                    return;
                }
                throw new InputMismatchException(parser);
            }
            case 9: 
            case 11: {
                this.reportUnwantedToken(parser);
                IntervalSet intervalSet2 = parser.getExpectedTokens();
                IntervalSet intervalSet3 = intervalSet2.or(this.getErrorRecoverySet(parser));
                this.consumeUntil(parser, intervalSet3);
                break;
            }
        }
    }

    protected void reportNoViableAlternative(Parser parser, NoViableAltException noViableAltException) {
        TokenStream tokenStream = parser.getInputStream();
        String string = tokenStream != null ? (noViableAltException.getStartToken().getType() == -1 ? "<EOF>" : tokenStream.getText(noViableAltException.getStartToken(), noViableAltException.getOffendingToken())) : "<unknown input>";
        String string2 = "no viable alternative at input " + this.escapeWSAndQuote(string);
        parser.notifyErrorListeners(noViableAltException.getOffendingToken(), string2, noViableAltException);
    }

    protected void reportInputMismatch(Parser parser, InputMismatchException inputMismatchException) {
        String string = "mismatched input " + this.getTokenErrorDisplay(inputMismatchException.getOffendingToken()) + " expecting " + inputMismatchException.getExpectedTokens().toString(parser.getVocabulary());
        parser.notifyErrorListeners(inputMismatchException.getOffendingToken(), string, inputMismatchException);
    }

    protected void reportFailedPredicate(Parser parser, FailedPredicateException failedPredicateException) {
        String string = parser.getRuleNames()[parser._ctx.getRuleIndex()];
        String string2 = "rule " + string + " " + failedPredicateException.getMessage();
        parser.notifyErrorListeners(failedPredicateException.getOffendingToken(), string2, failedPredicateException);
    }

    protected void reportUnwantedToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        Token token = parser.getCurrentToken();
        String string = this.getTokenErrorDisplay(token);
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        String string2 = "extraneous input " + string + " expecting " + intervalSet.toString(parser.getVocabulary());
        parser.notifyErrorListeners(token, string2, null);
    }

    protected void reportMissingToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        Token token = parser.getCurrentToken();
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        String string = "missing " + intervalSet.toString(parser.getVocabulary()) + " at " + this.getTokenErrorDisplay(token);
        parser.notifyErrorListeners(token, string, null);
    }

    @Override
    public Token recoverInline(Parser parser) {
        Token token = this.singleTokenDeletion(parser);
        if (token != null) {
            parser.consume();
            return token;
        }
        if (this.singleTokenInsertion(parser)) {
            return this.getMissingSymbol(parser);
        }
        InputMismatchException inputMismatchException = this.nextTokensContext == null ? new InputMismatchException(parser) : new InputMismatchException(parser, this.nextTokensState, this.nextTokensContext);
        throw inputMismatchException;
    }

    protected boolean singleTokenInsertion(Parser parser) {
        int n = parser.getInputStream().LA(1);
        ATNState aTNState = ((ParserATNSimulator)parser.getInterpreter()).atn.states.get(parser.getState());
        ATN aTN = ((ParserATNSimulator)parser.getInterpreter()).atn;
        ATNState aTNState2 = aTNState.transition((int)0).target;
        IntervalSet intervalSet = aTN.nextTokens(aTNState2, parser._ctx);
        if (intervalSet.contains(n)) {
            this.reportMissingToken(parser);
            return true;
        }
        return false;
    }

    protected Token singleTokenDeletion(Parser parser) {
        int n = parser.getInputStream().LA(2);
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        if (intervalSet.contains(n)) {
            this.reportUnwantedToken(parser);
            parser.consume();
            Token token = parser.getCurrentToken();
            this.reportMatch(parser);
            return token;
        }
        return null;
    }

    protected Token getMissingSymbol(Parser parser) {
        Token token = parser.getCurrentToken();
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        int n = 0;
        if (!intervalSet.isNil()) {
            n = intervalSet.getMinElement();
        }
        String string = n == -1 ? "<missing EOF>" : "<missing " + parser.getVocabulary().getDisplayName(n) + ">";
        Token token2 = token;
        Token token3 = parser.getInputStream().LT(-1);
        if (token2.getType() == -1 && token3 != null) {
            token2 = token3;
        }
        return parser.getTokenFactory().create(new Pair<TokenSource, CharStream>(token2.getTokenSource(), token2.getTokenSource().getInputStream()), n, string, 0, -1, -1, token2.getLine(), token2.getCharPositionInLine());
    }

    protected IntervalSet getExpectedTokens(Parser parser) {
        return parser.getExpectedTokens();
    }

    protected String getTokenErrorDisplay(Token token) {
        if (token == null) {
            return "<no token>";
        }
        String string = this.getSymbolText(token);
        if (string == null) {
            string = this.getSymbolType(token) == -1 ? "<EOF>" : "<" + this.getSymbolType(token) + ">";
        }
        return this.escapeWSAndQuote(string);
    }

    protected String getSymbolText(Token token) {
        return token.getText();
    }

    protected int getSymbolType(Token token) {
        return token.getType();
    }

    protected String escapeWSAndQuote(String string) {
        string = string.replace("\n", "\\n");
        string = string.replace("\r", "\\r");
        string = string.replace("\t", "\\t");
        return "'" + string + "'";
    }

    protected IntervalSet getErrorRecoverySet(Parser parser) {
        ATN aTN = ((ParserATNSimulator)parser.getInterpreter()).atn;
        RuleContext ruleContext = parser._ctx;
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        while (ruleContext != null && ruleContext.invokingState >= 0) {
            ATNState aTNState = aTN.states.get(ruleContext.invokingState);
            RuleTransition ruleTransition = (RuleTransition)aTNState.transition(0);
            IntervalSet intervalSet2 = aTN.nextTokens(ruleTransition.followState);
            intervalSet.addAll(intervalSet2);
            ruleContext = ruleContext.parent;
        }
        intervalSet.remove(-2);
        return intervalSet;
    }

    protected void consumeUntil(Parser parser, IntervalSet intervalSet) {
        int n = parser.getInputStream().LA(1);
        while (n != -1 && !intervalSet.contains(n)) {
            parser.consume();
            n = parser.getInputStream().LA(1);
        }
    }
}

