/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.atn.ATNConfig;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.SemanticContext;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.Array2DHashSet;
import org.antlr.v4.runtime.misc.DoubleKeyMap;

public class ATNConfigSet
implements Set<ATNConfig> {
    protected boolean readonly = false;
    public AbstractConfigHashSet configLookup;
    public final ArrayList<ATNConfig> configs = new ArrayList(7);
    public int uniqueAlt;
    protected BitSet conflictingAlts;
    public boolean hasSemanticContext;
    public boolean dipsIntoOuterContext;
    public final boolean fullCtx;
    private int cachedHashCode = -1;

    public ATNConfigSet(boolean bl) {
        this.configLookup = new ConfigHashSet();
        this.fullCtx = bl;
    }

    public ATNConfigSet() {
        this(true);
    }

    public ATNConfigSet(ATNConfigSet aTNConfigSet) {
        this(aTNConfigSet.fullCtx);
        this.addAll(aTNConfigSet);
        this.uniqueAlt = aTNConfigSet.uniqueAlt;
        this.conflictingAlts = aTNConfigSet.conflictingAlts;
        this.hasSemanticContext = aTNConfigSet.hasSemanticContext;
        this.dipsIntoOuterContext = aTNConfigSet.dipsIntoOuterContext;
    }

    @Override
    public boolean add(ATNConfig aTNConfig) {
        return this.add(aTNConfig, null);
    }

    public boolean add(ATNConfig aTNConfig, DoubleKeyMap<PredictionContext, PredictionContext, PredictionContext> doubleKeyMap) {
        ATNConfig aTNConfig2;
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        if (aTNConfig.semanticContext != SemanticContext.NONE) {
            this.hasSemanticContext = true;
        }
        if (aTNConfig.getOuterContextDepth() > 0) {
            this.dipsIntoOuterContext = true;
        }
        if ((aTNConfig2 = this.configLookup.getOrAdd(aTNConfig)) == aTNConfig) {
            this.cachedHashCode = -1;
            this.configs.add(aTNConfig);
            return true;
        }
        boolean bl = !this.fullCtx;
        PredictionContext predictionContext = PredictionContext.merge(aTNConfig2.context, aTNConfig.context, bl, doubleKeyMap);
        aTNConfig2.reachesIntoOuterContext = Math.max(aTNConfig2.reachesIntoOuterContext, aTNConfig.reachesIntoOuterContext);
        if (aTNConfig.isPrecedenceFilterSuppressed()) {
            aTNConfig2.setPrecedenceFilterSuppressed(true);
        }
        aTNConfig2.context = predictionContext;
        return true;
    }

    public List<ATNConfig> elements() {
        return this.configs;
    }

    public Set<ATNState> getStates() {
        HashSet<ATNState> hashSet = new HashSet<ATNState>();
        for (ATNConfig aTNConfig : this.configs) {
            hashSet.add(aTNConfig.state);
        }
        return hashSet;
    }

    public BitSet getAlts() {
        BitSet bitSet = new BitSet();
        for (ATNConfig aTNConfig : this.configs) {
            bitSet.set(aTNConfig.alt);
        }
        return bitSet;
    }

    public List<SemanticContext> getPredicates() {
        ArrayList<SemanticContext> arrayList = new ArrayList<SemanticContext>();
        for (ATNConfig aTNConfig : this.configs) {
            if (aTNConfig.semanticContext == SemanticContext.NONE) continue;
            arrayList.add(aTNConfig.semanticContext);
        }
        return arrayList;
    }

    public ATNConfig get(int n) {
        return this.configs.get(n);
    }

    public void optimizeConfigs(ATNSimulator aTNSimulator) {
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        if (this.configLookup.isEmpty()) {
            return;
        }
        for (ATNConfig aTNConfig : this.configs) {
            aTNConfig.context = aTNSimulator.getCachedContext(aTNConfig.context);
        }
    }

    @Override
    public boolean addAll(Collection<? extends ATNConfig> collection) {
        for (ATNConfig aTNConfig : collection) {
            this.add(aTNConfig);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ATNConfigSet)) {
            return false;
        }
        ATNConfigSet aTNConfigSet = (ATNConfigSet)object;
        boolean bl = this.configs != null && this.configs.equals(aTNConfigSet.configs) && this.fullCtx == aTNConfigSet.fullCtx && this.uniqueAlt == aTNConfigSet.uniqueAlt && this.conflictingAlts == aTNConfigSet.conflictingAlts && this.hasSemanticContext == aTNConfigSet.hasSemanticContext && this.dipsIntoOuterContext == aTNConfigSet.dipsIntoOuterContext;
        return bl;
    }

    @Override
    public int hashCode() {
        if (this.isReadonly()) {
            if (this.cachedHashCode == -1) {
                this.cachedHashCode = this.configs.hashCode();
            }
            return this.cachedHashCode;
        }
        return this.configs.hashCode();
    }

    @Override
    public int size() {
        return this.configs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.configs.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        if (this.configLookup == null) {
            throw new UnsupportedOperationException("This method is not implemented for readonly sets.");
        }
        return this.configLookup.contains(object);
    }

    public boolean containsFast(ATNConfig aTNConfig) {
        if (this.configLookup == null) {
            throw new UnsupportedOperationException("This method is not implemented for readonly sets.");
        }
        return this.configLookup.containsFast(aTNConfig);
    }

    @Override
    public Iterator<ATNConfig> iterator() {
        return this.configs.iterator();
    }

    @Override
    public void clear() {
        if (this.readonly) {
            throw new IllegalStateException("This set is readonly");
        }
        this.configs.clear();
        this.cachedHashCode = -1;
        this.configLookup.clear();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.configLookup = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.elements().toString());
        if (this.hasSemanticContext) {
            stringBuilder.append(",hasSemanticContext=").append(this.hasSemanticContext);
        }
        if (this.uniqueAlt != 0) {
            stringBuilder.append(",uniqueAlt=").append(this.uniqueAlt);
        }
        if (this.conflictingAlts != null) {
            stringBuilder.append(",conflictingAlts=").append(this.conflictingAlts);
        }
        if (this.dipsIntoOuterContext) {
            stringBuilder.append(",dipsIntoOuterContext");
        }
        return stringBuilder.toString();
    }

    public ATNConfig[] toArray() {
        return (ATNConfig[])this.configLookup.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.configLookup.toArray((U[])TArray);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public static abstract class AbstractConfigHashSet
    extends Array2DHashSet<ATNConfig> {
        public AbstractConfigHashSet(AbstractEqualityComparator<? super ATNConfig> abstractEqualityComparator) {
            this(abstractEqualityComparator, 16, 2);
        }

        public AbstractConfigHashSet(AbstractEqualityComparator<? super ATNConfig> abstractEqualityComparator, int n, int n2) {
            super(abstractEqualityComparator, n, n2);
        }

        @Override
        protected final ATNConfig asElementType(Object object) {
            if (!(object instanceof ATNConfig)) {
                return null;
            }
            return (ATNConfig)object;
        }

        protected final ATNConfig[][] createBuckets(int n) {
            return new ATNConfig[n][];
        }

        protected final ATNConfig[] createBucket(int n) {
            return new ATNConfig[n];
        }
    }

    public static final class ConfigEqualityComparator
    extends AbstractEqualityComparator<ATNConfig> {
        public static final ConfigEqualityComparator INSTANCE = new ConfigEqualityComparator();

        private ConfigEqualityComparator() {
        }

        @Override
        public int hashCode(ATNConfig aTNConfig) {
            int n = 7;
            n = 31 * n + aTNConfig.state.stateNumber;
            n = 31 * n + aTNConfig.alt;
            n = 31 * n + aTNConfig.semanticContext.hashCode();
            return n;
        }

        @Override
        public boolean equals(ATNConfig aTNConfig, ATNConfig aTNConfig2) {
            if (aTNConfig == aTNConfig2) {
                return true;
            }
            if (aTNConfig == null || aTNConfig2 == null) {
                return false;
            }
            return aTNConfig.state.stateNumber == aTNConfig2.state.stateNumber && aTNConfig.alt == aTNConfig2.alt && aTNConfig.semanticContext.equals(aTNConfig2.semanticContext);
        }
    }

    public static class ConfigHashSet
    extends AbstractConfigHashSet {
        public ConfigHashSet() {
            super(ConfigEqualityComparator.INSTANCE);
        }
    }
}

