/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.atn.LexerAction;
import org.antlr.v4.runtime.atn.LexerIndexedCustomAction;
import org.antlr.v4.runtime.misc.MurmurHash;

public class LexerActionExecutor {
    private final LexerAction[] lexerActions;
    private final int hashCode;

    public LexerActionExecutor(LexerAction[] lexerActionArray) {
        this.lexerActions = lexerActionArray;
        int n = MurmurHash.initialize();
        for (LexerAction lexerAction : lexerActionArray) {
            n = MurmurHash.update(n, lexerAction);
        }
        this.hashCode = MurmurHash.finish(n, lexerActionArray.length);
    }

    public static LexerActionExecutor append(LexerActionExecutor lexerActionExecutor, LexerAction lexerAction) {
        if (lexerActionExecutor == null) {
            return new LexerActionExecutor(new LexerAction[]{lexerAction});
        }
        LexerAction[] lexerActionArray = Arrays.copyOf(lexerActionExecutor.lexerActions, lexerActionExecutor.lexerActions.length + 1);
        lexerActionArray[lexerActionArray.length - 1] = lexerAction;
        return new LexerActionExecutor(lexerActionArray);
    }

    public LexerActionExecutor fixOffsetBeforeMatch(int n) {
        LexerAction[] lexerActionArray = null;
        for (int i = 0; i < this.lexerActions.length; ++i) {
            if (!this.lexerActions[i].isPositionDependent() || this.lexerActions[i] instanceof LexerIndexedCustomAction) continue;
            if (lexerActionArray == null) {
                lexerActionArray = (LexerAction[])this.lexerActions.clone();
            }
            lexerActionArray[i] = new LexerIndexedCustomAction(n, this.lexerActions[i]);
        }
        if (lexerActionArray == null) {
            return this;
        }
        return new LexerActionExecutor(lexerActionArray);
    }

    public LexerAction[] getLexerActions() {
        return this.lexerActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Lexer lexer, CharStream charStream, int n) {
        boolean bl = false;
        int n2 = charStream.index();
        try {
            for (LexerAction lexerAction : this.lexerActions) {
                if (lexerAction instanceof LexerIndexedCustomAction) {
                    int n3 = ((LexerIndexedCustomAction)lexerAction).getOffset();
                    charStream.seek(n + n3);
                    lexerAction = ((LexerIndexedCustomAction)lexerAction).getAction();
                    bl = n + n3 != n2;
                } else if (lexerAction.isPositionDependent()) {
                    charStream.seek(n2);
                    bl = false;
                }
                lexerAction.execute(lexer);
            }
        }
        finally {
            if (bl) {
                charStream.seek(n2);
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LexerActionExecutor)) {
            return false;
        }
        LexerActionExecutor lexerActionExecutor = (LexerActionExecutor)object;
        return this.hashCode == lexerActionExecutor.hashCode && Arrays.equals(this.lexerActions, lexerActionExecutor.lexerActions);
    }
}

