/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super K> comparator;
    protected LinkedList<Entry<K, V>>[] buckets;
    protected int n = 0;
    protected int threshold = 12;
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public FlexibleHashMap() {
        this(null, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator<? super K> abstractEqualityComparator) {
        this(abstractEqualityComparator, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator<? super K> objectEqualityComparator, int n, int n2) {
        if (objectEqualityComparator == null) {
            objectEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = objectEqualityComparator;
        this.buckets = FlexibleHashMap.createEntryListArray(n2);
        this.initialBucketCapacity = n2;
    }

    private static <K, V> LinkedList<Entry<K, V>>[] createEntryListArray(int n) {
        LinkedList[] linkedListArray = new LinkedList[n];
        return linkedListArray;
    }

    protected int getBucket(K k) {
        int n = this.comparator.hashCode(k);
        int n2 = n & this.buckets.length - 1;
        return n2;
    }

    @Override
    public V get(Object object) {
        Object object2 = object;
        if (object == null) {
            return null;
        }
        int n = this.getBucket(object2);
        LinkedList<Entry<K, V>> linkedList = this.buckets[n];
        if (linkedList == null) {
            return null;
        }
        for (Entry entry : linkedList) {
            if (!this.comparator.equals(entry.key, object2)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        int n;
        LinkedList<Entry<K, V>> linkedList;
        if (k == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        if ((linkedList = this.buckets[n = this.getBucket(k)]) == null) {
            this.buckets[n] = new LinkedList();
            linkedList = this.buckets[n];
        }
        for (Entry entry : linkedList) {
            if (!this.comparator.equals(entry.key, k)) continue;
            Object v2 = entry.value;
            entry.value = v;
            ++this.n;
            return v2;
        }
        linkedList.add(new Entry<K, V>(k, v));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList arrayList = new ArrayList(this.size());
        for (LinkedList<Entry<K, V>> linkedList : this.buckets) {
            if (linkedList == null) continue;
            for (Entry entry : linkedList) {
                arrayList.add(entry.value);
            }
        }
        return arrayList;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n = MurmurHash.initialize();
        for (LinkedList<Entry<K, V>> linkedList : this.buckets) {
            Entry entry;
            if (linkedList == null) continue;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext() && (entry = (Entry)iterator.next()) != null) {
                n = MurmurHash.update(n, this.comparator.hashCode(entry.key));
            }
        }
        n = MurmurHash.finish(n, this.size());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    protected void expand() {
        LinkedList<Entry<K, V>>[] linkedListArray = this.buckets;
        this.currentPrime += 4;
        int n = this.buckets.length * 2;
        LinkedList<Entry<K, V>>[] linkedListArray2 = FlexibleHashMap.createEntryListArray(n);
        this.buckets = linkedListArray2;
        this.threshold = (int)((double)n * 0.75);
        int n2 = this.size();
        for (LinkedList<Entry<K, V>> linkedList : linkedListArray) {
            Entry entry;
            if (linkedList == null) continue;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext() && (entry = (Entry)iterator.next()) != null) {
                this.put(entry.key, entry.value);
            }
        }
        this.n = n2;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = FlexibleHashMap.createEntryListArray(16);
        this.n = 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        for (LinkedList<Entry<K, V>> linkedList : this.buckets) {
            Entry entry;
            if (linkedList == null) continue;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext() && (entry = (Entry)iterator.next()) != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.toString());
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toTableString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LinkedList<Entry<K, V>> linkedList : this.buckets) {
            if (linkedList == null) {
                stringBuilder.append("null\n");
                continue;
            }
            stringBuilder.append('[');
            boolean bl = true;
            for (Entry entry : linkedList) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" ");
                }
                if (entry == null) {
                    stringBuilder.append("_");
                    continue;
                }
                stringBuilder.append(entry.toString());
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        FlexibleHashMap<String, Integer> flexibleHashMap = new FlexibleHashMap<String, Integer>();
        flexibleHashMap.put("hi", 1);
        flexibleHashMap.put("mom", 2);
        flexibleHashMap.put("foo", 3);
        flexibleHashMap.put("ach", 4);
        flexibleHashMap.put("cbba", 5);
        flexibleHashMap.put("d", 6);
        flexibleHashMap.put("edf", 7);
        flexibleHashMap.put("mom", 8);
        flexibleHashMap.put("hi", 9);
        System.out.println(flexibleHashMap);
        System.out.println(flexibleHashMap.toTableString());
    }

    public static class Entry<K, V> {
        public final K key;
        public V value;

        public Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

