/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.IntervalSet;

public class Utils {
    public static <T> String join(Iterator<T> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static <T> String join(T[] TArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < TArray.length; ++i) {
            stringBuilder.append(TArray[i]);
            if (i >= TArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int numNonnull(Object[] objectArray) {
        int n = 0;
        if (objectArray == null) {
            return n;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            ++n;
        }
        return n;
    }

    public static <T> void removeAllElements(Collection<T> collection, T t) {
        if (collection == null) {
            return;
        }
        while (collection.contains(t)) {
            collection.remove(t);
        }
    }

    public static String escapeWhitespace(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == ' ' && bl) {
                stringBuilder.append('\u00b7');
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void writeFile(String string, String string2) {
        Utils.writeFile(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String string, String string2, String string3) {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try (OutputStreamWriter outputStreamWriter = string3 != null ? new OutputStreamWriter((OutputStream)fileOutputStream, string3) : new OutputStreamWriter(fileOutputStream);){
            outputStreamWriter.write(string2);
        }
    }

    public static char[] readFile(String string) {
        return Utils.readFile(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFile(String string, String string2) {
        File file = new File(string);
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(string);
        char[] cArray = null;
        try (InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader((InputStream)fileInputStream, string2) : new InputStreamReader(fileInputStream);){
            cArray = new char[n];
            int n2 = inputStreamReader.read(cArray);
            if (n2 < cArray.length) {
                cArray = Arrays.copyOf(cArray, n2);
            }
        }
        return cArray;
    }

    public static Map<String, Integer> toMap(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], i);
        }
        return hashMap;
    }

    public static char[] toCharArray(IntegerList integerList) {
        if (integerList == null) {
            return null;
        }
        return integerList.toCharArray();
    }

    public static IntervalSet toSet(BitSet bitSet) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            intervalSet.add(n);
            n = bitSet.nextSetBit(n + 1);
        }
        return intervalSet;
    }

    public static String expandTabs(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    n2 = 0;
                    stringBuilder.append(c);
                    continue block4;
                }
                case '\t': {
                    int n3 = n - n2 % n;
                    n2 += n3;
                    stringBuilder.append(Utils.spaces(n3));
                    continue block4;
                }
                default: {
                    ++n2;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String spaces(int n) {
        return Utils.sequence(n, " ");
    }

    public static String newlines(int n) {
        return Utils.sequence(n, "\n");
    }

    public static String sequence(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int count(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }
}

