/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.ListTokenSource;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserInterpreter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.MultiMap;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.pattern.Chunk;
import org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;
import org.antlr.v4.runtime.tree.pattern.RuleTagToken;
import org.antlr.v4.runtime.tree.pattern.TagChunk;
import org.antlr.v4.runtime.tree.pattern.TextChunk;
import org.antlr.v4.runtime.tree.pattern.TokenTagToken;

public class ParseTreePatternMatcher {
    private final Lexer lexer;
    private final Parser parser;
    protected String start = "<";
    protected String stop = ">";
    protected String escape = "\\";

    public ParseTreePatternMatcher(Lexer lexer, Parser parser) {
        this.lexer = lexer;
        this.parser = parser;
    }

    public void setDelimiters(String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("start cannot be null or empty");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("stop cannot be null or empty");
        }
        this.start = string;
        this.stop = string2;
        this.escape = string3;
    }

    public boolean matches(ParseTree parseTree, String string, int n) {
        ParseTreePattern parseTreePattern = this.compile(string, n);
        return this.matches(parseTree, parseTreePattern);
    }

    public boolean matches(ParseTree parseTree, ParseTreePattern parseTreePattern) {
        MultiMap<String, ParseTree> multiMap = new MultiMap<String, ParseTree>();
        ParseTree parseTree2 = this.matchImpl(parseTree, parseTreePattern.getPatternTree(), multiMap);
        return parseTree2 == null;
    }

    public ParseTreeMatch match(ParseTree parseTree, String string, int n) {
        ParseTreePattern parseTreePattern = this.compile(string, n);
        return this.match(parseTree, parseTreePattern);
    }

    public ParseTreeMatch match(ParseTree parseTree, ParseTreePattern parseTreePattern) {
        MultiMap<String, ParseTree> multiMap = new MultiMap<String, ParseTree>();
        ParseTree parseTree2 = this.matchImpl(parseTree, parseTreePattern.getPatternTree(), multiMap);
        return new ParseTreeMatch(parseTree, parseTreePattern, multiMap, parseTree2);
    }

    public ParseTreePattern compile(String string, int n) {
        List<? extends Token> list2 = this.tokenize(string);
        ListTokenSource listTokenSource = new ListTokenSource(list2);
        CommonTokenStream commonTokenStream = new CommonTokenStream(listTokenSource);
        ParserInterpreter parserInterpreter = new ParserInterpreter(this.parser.getGrammarFileName(), this.parser.getVocabulary(), Arrays.asList(this.parser.getRuleNames()), this.parser.getATNWithBypassAlts(), (TokenStream)commonTokenStream);
        ParserRuleContext parserRuleContext = null;
        try {
            parserInterpreter.setErrorHandler(new BailErrorStrategy());
            parserRuleContext = parserInterpreter.parse(n);
        }
        catch (ParseCancellationException parseCancellationException) {
            throw (RecognitionException)parseCancellationException.getCause();
        }
        catch (RecognitionException recognitionException) {
            throw recognitionException;
        }
        catch (Exception exception) {
            throw new CannotInvokeStartRule(exception);
        }
        if (commonTokenStream.LA(1) != -1) {
            throw new StartRuleDoesNotConsumeFullPattern();
        }
        return new ParseTreePattern(this, string, n, parserRuleContext);
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public Parser getParser() {
        return this.parser;
    }

    protected ParseTree matchImpl(ParseTree parseTree, ParseTree parseTree2, MultiMap<String, ParseTree> multiMap) {
        if (parseTree == null) {
            throw new IllegalArgumentException("tree cannot be null");
        }
        if (parseTree2 == null) {
            throw new IllegalArgumentException("patternTree cannot be null");
        }
        if (parseTree instanceof TerminalNode && parseTree2 instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)parseTree;
            TerminalNode terminalNode2 = (TerminalNode)parseTree2;
            TerminalNode terminalNode3 = null;
            if (terminalNode.getSymbol().getType() == terminalNode2.getSymbol().getType()) {
                if (terminalNode2.getSymbol() instanceof TokenTagToken) {
                    TokenTagToken tokenTagToken = (TokenTagToken)terminalNode2.getSymbol();
                    multiMap.map(tokenTagToken.getTokenName(), parseTree);
                    if (tokenTagToken.getLabel() != null) {
                        multiMap.map(tokenTagToken.getLabel(), parseTree);
                    }
                } else if (!terminalNode.getText().equals(terminalNode2.getText()) && terminalNode3 == null) {
                    terminalNode3 = terminalNode;
                }
            } else if (terminalNode3 == null) {
                terminalNode3 = terminalNode;
            }
            return terminalNode3;
        }
        if (parseTree instanceof ParserRuleContext && parseTree2 instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)parseTree;
            ParserRuleContext parserRuleContext2 = (ParserRuleContext)parseTree2;
            ParserRuleContext parserRuleContext3 = null;
            RuleTagToken ruleTagToken = this.getRuleTagToken(parserRuleContext2);
            if (ruleTagToken != null) {
                Object var8_12 = null;
                if (parserRuleContext.getRuleContext().getRuleIndex() == parserRuleContext2.getRuleContext().getRuleIndex()) {
                    multiMap.map(ruleTagToken.getRuleName(), parseTree);
                    if (ruleTagToken.getLabel() != null) {
                        multiMap.map(ruleTagToken.getLabel(), parseTree);
                    }
                } else if (parserRuleContext3 == null) {
                    parserRuleContext3 = parserRuleContext;
                }
                return parserRuleContext3;
            }
            if (parserRuleContext.getChildCount() != parserRuleContext2.getChildCount()) {
                if (parserRuleContext3 == null) {
                    parserRuleContext3 = parserRuleContext;
                }
                return parserRuleContext3;
            }
            int n = parserRuleContext.getChildCount();
            for (int i = 0; i < n; ++i) {
                ParseTree parseTree3 = this.matchImpl(parserRuleContext.getChild(i), parseTree2.getChild(i), multiMap);
                if (parseTree3 == null) continue;
                return parseTree3;
            }
            return parserRuleContext3;
        }
        return parseTree;
    }

    protected RuleTagToken getRuleTagToken(ParseTree parseTree) {
        TerminalNode terminalNode;
        RuleNode ruleNode;
        if (parseTree instanceof RuleNode && (ruleNode = (RuleNode)parseTree).getChildCount() == 1 && ruleNode.getChild(0) instanceof TerminalNode && (terminalNode = (TerminalNode)ruleNode.getChild(0)).getSymbol() instanceof RuleTagToken) {
            return (RuleTagToken)terminalNode.getSymbol();
        }
        return null;
    }

    public List<? extends Token> tokenize(String string) {
        List<Chunk> list2 = this.split(string);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (Chunk chunk : list2) {
            Token token;
            Object object;
            Chunk chunk2;
            if (chunk instanceof TagChunk) {
                chunk2 = (TagChunk)chunk;
                if (Character.isUpperCase(((TagChunk)chunk2).getTag().charAt(0))) {
                    object = this.parser.getTokenType(((TagChunk)chunk2).getTag());
                    if ((Integer)object == 0) {
                        throw new IllegalArgumentException("Unknown token " + ((TagChunk)chunk2).getTag() + " in pattern: " + string);
                    }
                    token = new TokenTagToken(((TagChunk)chunk2).getTag(), (Integer)object, ((TagChunk)chunk2).getLabel());
                    arrayList.add(token);
                    continue;
                }
                if (Character.isLowerCase(((TagChunk)chunk2).getTag().charAt(0))) {
                    int n = this.parser.getRuleIndex(((TagChunk)chunk2).getTag());
                    if (n == -1) {
                        throw new IllegalArgumentException("Unknown rule " + ((TagChunk)chunk2).getTag() + " in pattern: " + string);
                    }
                    int n2 = this.parser.getATNWithBypassAlts().ruleToTokenType[n];
                    arrayList.add(new RuleTagToken(((TagChunk)chunk2).getTag(), n2, ((TagChunk)chunk2).getLabel()));
                    continue;
                }
                throw new IllegalArgumentException("invalid tag: " + ((TagChunk)chunk2).getTag() + " in pattern: " + string);
            }
            chunk2 = (TextChunk)chunk;
            object = new ANTLRInputStream(((TextChunk)chunk2).getText());
            this.lexer.setInputStream((IntStream)object);
            token = this.lexer.nextToken();
            while (token.getType() != -1) {
                arrayList.add(token);
                token = this.lexer.nextToken();
            }
        }
        return arrayList;
    }

    public List<Chunk> split(String string) {
        String string2;
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        int n3 = string.length();
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        while (n2 < n3) {
            if (n2 == string.indexOf(this.escape + this.start, n2)) {
                n2 += this.escape.length() + this.start.length();
                continue;
            }
            if (n2 == string.indexOf(this.escape + this.stop, n2)) {
                n2 += this.escape.length() + this.stop.length();
                continue;
            }
            if (n2 == string.indexOf(this.start, n2)) {
                arrayList2.add(n2);
                n2 += this.start.length();
                continue;
            }
            if (n2 == string.indexOf(this.stop, n2)) {
                arrayList3.add(n2);
                n2 += this.stop.length();
                continue;
            }
            ++n2;
        }
        if (arrayList2.size() > arrayList3.size()) {
            throw new IllegalArgumentException("unterminated tag in pattern: " + string);
        }
        if (arrayList2.size() < arrayList3.size()) {
            throw new IllegalArgumentException("missing start tag in pattern: " + string);
        }
        int n4 = arrayList2.size();
        for (n = 0; n < n4; ++n) {
            if ((Integer)arrayList2.get(n) < (Integer)arrayList3.get(n)) continue;
            throw new IllegalArgumentException("tag delimiters out of order in pattern: " + string);
        }
        if (n4 == 0) {
            String string3 = string.substring(0, n3);
            arrayList.add(new TextChunk(string3));
        }
        if (n4 > 0 && (Integer)arrayList2.get(0) > 0) {
            String string4 = string.substring(0, (Integer)arrayList2.get(0));
            arrayList.add(new TextChunk(string4));
        }
        for (n = 0; n < n4; ++n) {
            object = object2 = string.substring((Integer)arrayList2.get(n) + this.start.length(), (Integer)arrayList3.get(n));
            string2 = null;
            int n5 = ((String)object2).indexOf(58);
            if (n5 >= 0) {
                string2 = ((String)object2).substring(0, n5);
                object = ((String)object2).substring(n5 + 1, ((String)object2).length());
            }
            arrayList.add(new TagChunk(string2, (String)object));
            if (n + 1 >= n4) continue;
            String string5 = string.substring((Integer)arrayList3.get(n) + this.stop.length(), (Integer)arrayList2.get(n + 1));
            arrayList.add(new TextChunk(string5));
        }
        if (n4 > 0 && (n = (Integer)arrayList3.get(n4 - 1) + this.stop.length()) < n3) {
            object2 = string.substring(n, n3);
            arrayList.add(new TextChunk((String)object2));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = (Chunk)arrayList.get(n);
            if (!(object2 instanceof TextChunk) || (string2 = ((TextChunk)(object = (TextChunk)object2)).getText().replace(this.escape, "")).length() >= ((TextChunk)object).getText().length()) continue;
            arrayList.set(n, new TextChunk(string2));
        }
        return arrayList;
    }

    public static class StartRuleDoesNotConsumeFullPattern
    extends RuntimeException {
    }

    public static class CannotInvokeStartRule
    extends RuntimeException {
        public CannotInvokeStartRule(Throwable throwable) {
            super(throwable);
        }
    }
}

