/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.xpath;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.misc.Interval;

public class XPathLexer
extends Lexer {
    public static final int TOKEN_REF = 1;
    public static final int RULE_REF = 2;
    public static final int ANYWHERE = 3;
    public static final int ROOT = 4;
    public static final int WILDCARD = 5;
    public static final int BANG = 6;
    public static final int ID = 7;
    public static final int STRING = 8;
    public static String[] modeNames = new String[]{"DEFAULT_MODE"};
    public static final String[] ruleNames = new String[]{"ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "NameChar", "NameStartChar", "STRING"};
    private static final String[] _LITERAL_NAMES = new String[]{null, null, null, "'//'", "'/'", "'*'", "'!'"};
    private static final String[] _SYMBOLIC_NAMES = new String[]{null, "TOKEN_REF", "RULE_REF", "ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "STRING"};
    public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);
    @Deprecated
    public static final String[] tokenNames = new String[_SYMBOLIC_NAMES.length];
    protected int line = 1;
    protected int charPositionInLine = 0;

    @Override
    public String getGrammarFileName() {
        return "XPathLexer.g4";
    }

    @Override
    public String[] getRuleNames() {
        return ruleNames;
    }

    @Override
    public String[] getModeNames() {
        return modeNames;
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public Vocabulary getVocabulary() {
        return VOCABULARY;
    }

    @Override
    public ATN getATN() {
        return null;
    }

    public XPathLexer(CharStream charStream) {
        super(charStream);
    }

    @Override
    public Token nextToken() {
        this._tokenStartCharIndex = this._input.index();
        CommonToken commonToken = null;
        block7: while (commonToken == null) {
            switch (this._input.LA(1)) {
                case 47: {
                    this.consume();
                    if (this._input.LA(1) == 47) {
                        this.consume();
                        commonToken = new CommonToken(3, "//");
                        continue block7;
                    }
                    commonToken = new CommonToken(4, "/");
                    continue block7;
                }
                case 42: {
                    this.consume();
                    commonToken = new CommonToken(5, "*");
                    continue block7;
                }
                case 33: {
                    this.consume();
                    commonToken = new CommonToken(6, "!");
                    continue block7;
                }
                case 39: {
                    String string = this.matchString();
                    commonToken = new CommonToken(8, string);
                    continue block7;
                }
                case -1: {
                    return new CommonToken(-1, "<EOF>");
                }
            }
            if (this.isNameStartChar(this._input.LA(1))) {
                String string = this.matchID();
                if (Character.isUpperCase(string.charAt(0))) {
                    commonToken = new CommonToken(1, string);
                    continue;
                }
                commonToken = new CommonToken(2, string);
                continue;
            }
            throw new LexerNoViableAltException(this, this._input, this._tokenStartCharIndex, null);
        }
        commonToken.setStartIndex(this._tokenStartCharIndex);
        commonToken.setCharPositionInLine(this._tokenStartCharIndex);
        commonToken.setLine(this.line);
        return commonToken;
    }

    public void consume() {
        int n = this._input.LA(1);
        if (n == 10) {
            ++this.line;
            this.charPositionInLine = 0;
        } else {
            ++this.charPositionInLine;
        }
        this._input.consume();
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public String matchID() {
        int n = this._input.index();
        this.consume();
        while (this.isNameChar(this._input.LA(1))) {
            this.consume();
        }
        return this._input.getText(Interval.of(n, this._input.index() - 1));
    }

    public String matchString() {
        int n = this._input.index();
        this.consume();
        while (this._input.LA(1) != 39) {
            this.consume();
        }
        this.consume();
        return this._input.getText(Interval.of(n, this._input.index() - 1));
    }

    public boolean isNameChar(int n) {
        return Character.isUnicodeIdentifierPart(n);
    }

    public boolean isNameStartChar(int n) {
        return Character.isUnicodeIdentifierStart(n);
    }

    static {
        for (int i = 0; i < tokenNames.length; ++i) {
            XPathLexer.tokenNames[i] = VOCABULARY.getLiteralName(i);
            if (tokenNames[i] == null) {
                XPathLexer.tokenNames[i] = VOCABULARY.getSymbolicName(i);
            }
            if (tokenNames[i] != null) continue;
            XPathLexer.tokenNames[i] = "<INVALID>";
        }
    }
}

