/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.api.entity;

import cn.inrhor.imipetcore.api.entity.ai.AiToolsKt;
import cn.inrhor.imipetcore.api.manager.AttributeManager;
import cn.inrhor.imipetcore.api.manager.DisguiseManager;
import cn.inrhor.imipetcore.api.manager.MetaManager;
import cn.inrhor.imipetcore.api.manager.ModelManager;
import cn.inrhor.imipetcore.api.manager.OptionManager;
import cn.inrhor.imipetcore.api.manager.PetManager;
import cn.inrhor.imipetcore.common.database.data.PetData;
import cn.inrhor.imipetcore.common.model.ModelSelect;
import cn.inrhor.imipetcore.common.option.ActionAiOption;
import cn.inrhor.imipetcore.common.option.Addon;
import cn.inrhor.imipetcore.common.option.AddonSelect;
import cn.inrhor.imipetcore.common.option.AddonType;
import cn.inrhor.imipetcore.common.option.ModelOption;
import cn.inrhor.imipetcore.common.option.PetOption;
import cn.inrhor.imipetcore.common.option.StateOption;
import cn.inrhor.imipetcore.common.script.kether.KetherHandleKt;
import cn.inrhor.imipetcore.common.script.kether.UiVariable;
import cn.inrhor.imipetcore.server.ReadManager;
import cn.inrhor.imipetcore.taboolib.common.platform.function.ExecutorKt;
import cn.inrhor.imipetcore.taboolib.common.platform.service.PlatformExecutor;
import cn.inrhor.imipetcore.taboolib.common5.Baffle;
import cn.inrhor.imipetcore.taboolib.module.ai.SimpleAiExecutorKt;
import cn.inrhor.imipetcore.taboolib.platform.util.BukkitLangKt;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import ink.ptms.adyeshach.api.AdyeshachAPI;
import java.util.List;
import kotlin.Metadata;
import kotlin180.Unit;
import kotlin180.jvm.functions.Function1;
import kotlin180.jvm.internal.Intrinsics;
import kotlin180.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0010\u0010$\u001a\u00020\u00182\b\b\u0002\u0010%\u001a\u00020\u001aR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcn/inrhor/imipetcore/api/entity/PetEntity;", "", "owner", "Lorg/bukkit/entity/Player;", "petData", "Lcn/inrhor/imipetcore/common/database/data/PetData;", "(Lorg/bukkit/entity/Player;Lcn/inrhor/imipetcore/common/database/data/PetData;)V", "actionBaffle", "Lcn/inrhor/imipetcore/taboolib/common5/Baffle;", "getActionBaffle", "()Lcn/inrhor/imipetcore/taboolib/common5/Baffle;", "setActionBaffle", "(Lcn/inrhor/imipetcore/taboolib/common5/Baffle;)V", "entity", "Lorg/bukkit/entity/LivingEntity;", "getEntity", "()Lorg/bukkit/entity/LivingEntity;", "setEntity", "(Lorg/bukkit/entity/LivingEntity;)V", "getOwner", "()Lorg/bukkit/entity/Player;", "getPetData", "()Lcn/inrhor/imipetcore/common/database/data/PetData;", "back", "", "update", "", "getStateOption", "", "Lcn/inrhor/imipetcore/common/option/StateOption;", "action", "", "initAction", "initAddon", "initAttribute", "spawn", "updateModel", "init", "imiPetCore"})
@SourceDebugExtension(value={"SMAP\nPetEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PetEntity.kt\ncn/inrhor/imipetcore/api/entity/PetEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1849#2,2:189\n1849#2,2:191\n1849#2,2:193\n*S KotlinDebug\n*F\n+ 1 PetEntity.kt\ncn/inrhor/imipetcore/api/entity/PetEntity\n*L\n92#1:189,2\n116#1:191,2\n182#1:193,2\n*E\n"})
public final class PetEntity {
    @NotNull
    private final Player owner;
    @NotNull
    private final PetData petData;
    @Nullable
    private LivingEntity entity;
    @Nullable
    private Baffle actionBaffle;

    public PetEntity(@NotNull Player owner, @NotNull PetData petData) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)petData, (String)"petData");
        this.owner = owner;
        this.petData = petData;
    }

    @NotNull
    public final Player getOwner() {
        return this.owner;
    }

    @NotNull
    public final PetData getPetData() {
        return this.petData;
    }

    @Nullable
    public final LivingEntity getEntity() {
        return this.entity;
    }

    public final void setEntity(@Nullable LivingEntity livingEntity) {
        this.entity = livingEntity;
    }

    @Nullable
    public final Baffle getActionBaffle() {
        return this.actionBaffle;
    }

    public final void setActionBaffle(@Nullable Baffle baffle) {
        this.actionBaffle = baffle;
    }

    public final void spawn() {
        if (this.petData.isDead()) {
            BukkitLangKt.sendLang((CommandSender)this.owner, "PET_IS_DEAD", new Object[0]);
            return;
        }
        if (this.entity != null) {
            return;
        }
        this.petData.setFollowing(true);
        Entity entity = this.owner.getWorld().spawnEntity(this.owner.getLocation(), EntityType.WOLF);
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity livingEntity = this.entity = (LivingEntity)entity;
        if (livingEntity != null) {
            MetaManager.INSTANCE.setMeta((Entity)livingEntity, "entity", this.petData.getName());
        }
        LivingEntity livingEntity2 = this.entity;
        Intrinsics.checkNotNull((Object)livingEntity2, (String)"null cannot be cast to non-null type org.bukkit.entity.Wolf");
        Wolf wolf = (Wolf)livingEntity2;
        wolf.setTamed(true);
        wolf.setSilent(false);
        wolf.setOwner((AnimalTamer)this.owner);
        this.initAttribute();
        this.initAction();
        this.updateModel(true);
        this.initAddon();
    }

    public final void initAttribute() {
        block0: {
            PetManager.setMaxHP$default(PetManager.INSTANCE, this.owner, this.petData, 0.0, false, 2, null);
            PetManager.setCurrentHP$default(PetManager.INSTANCE, this.owner, this.petData, 0.0, false, 2, null);
            PetManager.setPetSpeed$default(PetManager.INSTANCE, this.owner, this.petData, 0.0, false, 2, null);
            PetManager.setPetAttack$default(PetManager.INSTANCE, this.owner, this.petData, 0.0, false, 2, null);
            LivingEntity livingEntity = this.entity;
            if (livingEntity == null) break block0;
            AttributeManager.INSTANCE.loadAttributeData(livingEntity, this.petData);
        }
    }

    public final void initAction() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity != null) {
            SimpleAiExecutorKt.clearGoalAi(livingEntity);
        }
        LivingEntity livingEntity2 = this.entity;
        if (livingEntity2 != null) {
            SimpleAiExecutorKt.clearTargetAi(livingEntity2);
        }
        Iterable $this$forEach$iv = this.petData.petOption().getAction();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActionAiOption it = (ActionAiOption)element$iv;
            boolean bl = false;
            String id2 = it.getId();
            int pri = it.getPriority();
            LivingEntity livingEntity3 = this.entity;
            if (livingEntity3 == null) continue;
            AiToolsKt.addAi(livingEntity3, this, id2, pri);
        }
    }

    public final void back(boolean update2) {
        if (update2) {
            this.petData.setFollowing(false);
        }
        if (this.petData.isDead()) {
            return;
        }
        LivingEntity livingEntity = this.entity;
        if (livingEntity != null) {
            ModelManager.INSTANCE.clearModel((Entity)livingEntity, OptionManager.INSTANCE.model(this).getSelect());
        }
        LivingEntity livingEntity2 = this.entity;
        if (livingEntity2 != null) {
            livingEntity2.remove();
        }
        this.entity = null;
    }

    public static /* synthetic */ void back$default(PetEntity petEntity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        petEntity.back(bl);
    }

    public final void initAddon() {
        if (this.entity == null) {
            return;
        }
        PetOption petOption = this.petData.petOption();
        Iterable $this$forEach$iv = petOption.getAddon();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Addon it = (Addon)element$iv;
            boolean bl = false;
            if (WhenMappings.$EnumSwitchMapping$1[it.getType().ordinal()] != 1) continue;
            List<String> list = KetherHandleKt.evalStrPetData(this.owner, it.getLines(), this.petData, new UiVariable[0]);
            LivingEntity livingEntity = this.entity;
            Intrinsics.checkNotNull((Object)livingEntity);
            Intrinsics.checkNotNullExpressionValue((Object)livingEntity.getLocation().clone().add(0.0, it.getHeight(), 0.0), (String)"entity!!.location.clone().add(0.0, it.height, 0.0)");
            switch (WhenMappings.$EnumSwitchMapping$0[it.getSelect().ordinal()]) {
                case 1: {
                    Location loc;
                    if (!ReadManager.INSTANCE.getAdyeshachLoad()) {
                        return;
                    }
                    ink.ptms.adyeshach.api.Hologram holo = AdyeshachAPI.INSTANCE.createHologram(loc, list);
                    ExecutorKt.submit$default(false, true, 0L, 1L, null, (Function1)new Function1<PlatformExecutor.PlatformTask, Unit>(this, holo, it){
                        final /* synthetic */ PetEntity this$0;
                        final /* synthetic */ ink.ptms.adyeshach.api.Hologram<?> $holo;
                        final /* synthetic */ Addon $it;
                        {
                            this.this$0 = $receiver;
                            this.$holo = $holo;
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull PlatformExecutor.PlatformTask $this$submit) {
                            Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                            LivingEntity livingEntity = this.this$0.getEntity();
                            boolean bl = livingEntity != null ? livingEntity.isDead() : false;
                            if (bl || this.this$0.getEntity() == null) {
                                this.$holo.delete();
                                $this$submit.cancel();
                                return;
                            }
                            LivingEntity livingEntity2 = this.this$0.getEntity();
                            Intrinsics.checkNotNull((Object)livingEntity2);
                            Location location = livingEntity2.getLocation().clone().add(0.0, this.$it.getHeight(), 0.0);
                            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"entity!!.location.clone().add(0.0, it.height, 0.0)");
                            this.$holo.teleport(location);
                        }
                    }, 21, null);
                    break;
                }
                case 2: {
                    Location loc;
                    if (!ReadManager.INSTANCE.getDecentHologramsLoad()) {
                        return;
                    }
                    LivingEntity livingEntity2 = this.entity;
                    Intrinsics.checkNotNull((Object)livingEntity2);
                    ink.ptms.adyeshach.api.Hologram holo = DHAPI.createHologram((String)livingEntity2.getUniqueId().toString(), (Location)loc, list);
                    ExecutorKt.submit$default(false, true, 0L, 1L, null, (Function1)new Function1<PlatformExecutor.PlatformTask, Unit>(this, (Hologram)holo, it){
                        final /* synthetic */ PetEntity this$0;
                        final /* synthetic */ Hologram $holo;
                        final /* synthetic */ Addon $it;
                        {
                            this.this$0 = $receiver;
                            this.$holo = $holo;
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull PlatformExecutor.PlatformTask $this$submit) {
                            Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                            LivingEntity livingEntity = this.this$0.getEntity();
                            boolean bl = livingEntity != null ? livingEntity.isDead() : false;
                            if (bl || this.this$0.getEntity() == null) {
                                this.$holo.destroy();
                                $this$submit.cancel();
                                return;
                            }
                            LivingEntity livingEntity2 = this.this$0.getEntity();
                            Intrinsics.checkNotNull((Object)livingEntity2);
                            DHAPI.moveHologram((Hologram)this.$holo, (Location)livingEntity2.getLocation().clone().add(0.0, this.$it.getHeight(), 0.0));
                        }
                    }, 21, null);
                }
            }
        }
    }

    public final void updateModel(boolean init) {
        block2: {
            block1: {
                EntityType entityType = this.petData.petOption().getEntityType();
                if (OptionManager.INSTANCE.model(this).getSelect() != ModelSelect.COMMON) break block1;
                ExecutorKt.submit$default(false, false, 5L, 0L, null, (Function1)new Function1<PlatformExecutor.PlatformTask, Unit>(this, entityType){
                    final /* synthetic */ PetEntity this$0;
                    final /* synthetic */ EntityType $entityType;
                    {
                        this.this$0 = $receiver;
                        this.$entityType = $entityType;
                        super(1);
                    }

                    public final void invoke(@NotNull PlatformExecutor.PlatformTask $this$submit) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                            LivingEntity livingEntity = this.this$0.getEntity();
                            if (livingEntity == null) break block0;
                            DisguiseManager.INSTANCE.disguise((Entity)livingEntity, this.$entityType);
                        }
                    }
                }, 27, null);
                break block2;
            }
            ModelOption model = OptionManager.INSTANCE.model(this);
            String modelID = model.getId();
            if (!this.petData.isFollow()) {
                return;
            }
            LivingEntity livingEntity = this.entity;
            if (livingEntity == null) break block2;
            ModelManager.INSTANCE.display((Entity)livingEntity, modelID, init, model.getSelect());
        }
    }

    public static /* synthetic */ void updateModel$default(PetEntity petEntity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        petEntity.updateModel(bl);
    }

    @NotNull
    public final List<StateOption> getStateOption() {
        return this.petData.petOption().getModel().getState();
    }

    @Nullable
    public final StateOption getStateOption(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Iterable $this$forEach$iv = this.getStateOption();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateOption it = (StateOption)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)action)) continue;
            return it;
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AddonSelect.values().length];
            try {
                nArray[AddonSelect.ADYESHACH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddonSelect.DECENT_HOLOGRAMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AddonType.values().length];
            try {
                nArray[AddonType.NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

