/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.common.env;

import cn.inrhor.imipetcore.taboolib.common.env.AbstractXmlParser;
import cn.inrhor.imipetcore.taboolib.common.env.DependencyScope;
import cn.inrhor.imipetcore.taboolib.common.env.DependencyVersion;
import java.io.File;
import java.text.ParseException;
import java.util.Objects;
import org.w3c.dom.Element;

public class Dependency
extends AbstractXmlParser {
    private static final String LATEST_VERSION = "latest";
    private final String groupId;
    private final String artifactId;
    private final DependencyScope scope;
    private String version;

    public Dependency(String groupId, String artifactId, String version, DependencyScope scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version.contains("$") || version.contains("[") || version.contains("(") ? LATEST_VERSION : version;
        this.scope = scope;
    }

    public Dependency(Element node) throws ParseException {
        this(Dependency.find("groupId", node), Dependency.find("artifactId", node), Dependency.find("version", node, LATEST_VERSION), DependencyScope.valueOf(Dependency.find("scope", node, "runtime").toUpperCase()));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version.equals(LATEST_VERSION) ? null : this.version;
    }

    public void setVersion(String version) {
        if (!this.version.equals(LATEST_VERSION)) {
            throw new IllegalStateException("Version is already resolved");
        }
        if (version.equals(LATEST_VERSION)) {
            throw new IllegalArgumentException("Cannot set version to the latest");
        }
        this.version = version;
    }

    public DependencyVersion[] getInstalledVersions(File dir) {
        for (String part : this.getGroupId().split("\\.")) {
            dir = new File(dir, part);
        }
        String[] list = (dir = new File(dir, this.getArtifactId())).list();
        if (list == null) {
            return new DependencyVersion[0];
        }
        DependencyVersion[] versions = new DependencyVersion[list.length];
        for (int i = 0; i < list.length; ++i) {
            versions[i] = new DependencyVersion(list[i]);
        }
        return versions;
    }

    public DependencyScope getScope() {
        return this.scope;
    }

    public File getFile(File dir, String ext) {
        for (String part : this.getGroupId().split("\\.")) {
            dir = new File(dir, part);
        }
        dir = new File(dir, this.getArtifactId());
        dir = new File(dir, this.getVersion());
        dir = new File(dir, String.format("%s-%s.%s", this.getArtifactId(), this.getVersion(), ext));
        return dir;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getVersion(), that.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId());
    }
}

