/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.library.asm.commons;

import cn.inrhor.imipetcore.taboolib.library.asm.ConstantDynamic;
import cn.inrhor.imipetcore.taboolib.library.asm.Handle;
import cn.inrhor.imipetcore.taboolib.library.asm.Type;
import cn.inrhor.imipetcore.taboolib.library.asm.commons.SignatureRemapper;
import cn.inrhor.imipetcore.taboolib.library.asm.signature.SignatureReader;
import cn.inrhor.imipetcore.taboolib.library.asm.signature.SignatureVisitor;
import cn.inrhor.imipetcore.taboolib.library.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String descriptor) {
        return this.mapType(Type.getType(descriptor)).getDescriptor();
    }

    private Type mapType(Type type2) {
        switch (type2.getSort()) {
            case 9: {
                StringBuilder remappedDescriptor = new StringBuilder();
                for (int i = 0; i < type2.getDimensions(); ++i) {
                    remappedDescriptor.append('[');
                }
                remappedDescriptor.append(this.mapType(type2.getElementType()).getDescriptor());
                return Type.getType(remappedDescriptor.toString());
            }
            case 10: {
                String remappedInternalName = this.map(type2.getInternalName());
                return remappedInternalName != null ? Type.getObjectType(remappedInternalName) : type2;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type2.getDescriptor()));
            }
        }
        return type2;
    }

    public String mapType(String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(internalName)).getInternalName();
    }

    public String[] mapTypes(String[] internalNames) {
        String[] remappedInternalNames = null;
        for (int i = 0; i < internalNames.length; ++i) {
            String internalName = internalNames[i];
            String remappedInternalName = this.mapType(internalName);
            if (remappedInternalName == null) continue;
            if (remappedInternalNames == null) {
                remappedInternalNames = (String[])internalNames.clone();
            }
            remappedInternalNames[i] = remappedInternalName;
        }
        return remappedInternalNames != null ? remappedInternalNames : internalNames;
    }

    public String mapMethodDesc(String methodDescriptor) {
        if ("()V".equals(methodDescriptor)) {
            return methodDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type argumentType : Type.getArgumentTypes(methodDescriptor)) {
            stringBuilder.append(this.mapType(argumentType).getDescriptor());
        }
        Type returnType = Type.getReturnType(methodDescriptor);
        if (returnType == Type.VOID_TYPE) {
            stringBuilder.append(")V");
        } else {
            stringBuilder.append(')').append(this.mapType(returnType).getDescriptor());
        }
        return stringBuilder.toString();
    }

    public Object mapValue(Object value) {
        if (value instanceof Type) {
            return this.mapType((Type)value);
        }
        if (value instanceof Handle) {
            Handle handle2 = (Handle)value;
            boolean isFieldHandle = handle2.getTag() <= 4;
            return new Handle(handle2.getTag(), this.mapType(handle2.getOwner()), isFieldHandle ? this.mapFieldName(handle2.getOwner(), handle2.getName(), handle2.getDesc()) : this.mapMethodName(handle2.getOwner(), handle2.getName(), handle2.getDesc()), isFieldHandle ? this.mapDesc(handle2.getDesc()) : this.mapMethodDesc(handle2.getDesc()), handle2.isInterface());
        }
        if (value instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)value;
            int bootstrapMethodArgumentCount = constantDynamic.getBootstrapMethodArgumentCount();
            Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArgumentCount];
            for (int i = 0; i < bootstrapMethodArgumentCount; ++i) {
                remappedBootstrapMethodArguments[i] = this.mapValue(constantDynamic.getBootstrapMethodArgument(i));
            }
            String descriptor = constantDynamic.getDescriptor();
            return new ConstantDynamic(this.mapInvokeDynamicMethodName(constantDynamic.getName(), descriptor), this.mapDesc(descriptor), (Handle)this.mapValue(constantDynamic.getBootstrapMethod()), remappedBootstrapMethodArguments);
        }
        return value;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(signature);
        SignatureWriter signatureWriter2 = new SignatureWriter();
        SignatureVisitor signatureRemapper = this.createSignatureRemapper(signatureWriter2);
        if (typeSignature) {
            signatureReader.acceptType(signatureRemapper);
        } else {
            signatureReader.accept(signatureRemapper);
        }
        return signatureWriter2.toString();
    }

    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return this.createSignatureRemapper(signatureVisitor);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor signatureVisitor) {
        return new SignatureRemapper(signatureVisitor, this);
    }

    public String mapAnnotationAttributeName(String descriptor, String name2) {
        return name2;
    }

    public String mapInnerClassName(String name2, String ownerName, String innerName) {
        String remappedInnerName = this.mapType(name2);
        if (remappedInnerName.equals(name2)) {
            return innerName;
        }
        int originSplit = name2.lastIndexOf(47);
        int remappedSplit = remappedInnerName.lastIndexOf(47);
        if (originSplit != -1 && remappedSplit != -1 && name2.substring(originSplit).equals(remappedInnerName.substring(remappedSplit))) {
            return innerName;
        }
        if (remappedInnerName.contains("$")) {
            int index;
            for (index = remappedInnerName.lastIndexOf(36) + 1; index < remappedInnerName.length() && Character.isDigit(remappedInnerName.charAt(index)); ++index) {
            }
            return remappedInnerName.substring(index);
        }
        return innerName;
    }

    public String mapMethodName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapInvokeDynamicMethodName(String name2, String descriptor) {
        return name2;
    }

    public String mapRecordComponentName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapFieldName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapPackageName(String name2) {
        return name2;
    }

    public String mapModuleName(String name2) {
        return name2;
    }

    public String map(String internalName) {
        return internalName;
    }
}

