/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.library.jarrelocator;

import cn.inrhor.imipetcore.taboolib.library.asm.ClassReader;
import cn.inrhor.imipetcore.taboolib.library.asm.ClassWriter;
import cn.inrhor.imipetcore.taboolib.library.jarrelocator.RelocatingClassVisitor;
import cn.inrhor.imipetcore.taboolib.library.jarrelocator.RelocatingRemapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

final class JarRelocatorTask {
    private static final Pattern SIGNATURE_FILE_PATTERN = Pattern.compile("META-INF/(?:[^/]+\\.(?:DSA|RSA|SF)|SIG-[^/]+)");
    private static final Pattern SIGNATURE_PROPERTY_PATTERN = Pattern.compile(".*-Digest");
    private final RelocatingRemapper remapper;
    private final JarOutputStream jarOut;
    private final JarFile jarIn;
    private final Set<String> resources = new HashSet<String>();

    JarRelocatorTask(RelocatingRemapper remapper, JarOutputStream jarOut, JarFile jarIn) {
        this.remapper = remapper;
        this.jarOut = jarOut;
        this.jarIn = jarIn;
    }

    void processEntries() throws IOException {
        Enumeration<JarEntry> entries = this.jarIn.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name2 = entry.getName();
            if (name2.equals("META-INF/INDEX.LIST") || entry.isDirectory() || SIGNATURE_FILE_PATTERN.matcher(name2).matches()) continue;
            InputStream entryIn = this.jarIn.getInputStream(entry);
            try {
                this.processEntry(entry, entryIn);
            }
            finally {
                if (entryIn == null) continue;
                entryIn.close();
            }
        }
    }

    private void processEntry(JarEntry entry, InputStream entryIn) throws IOException {
        String name2 = entry.getName();
        String mappedName = this.remapper.map(name2);
        this.processDirectory(mappedName, true);
        if (name2.endsWith(".class")) {
            this.processClass(name2, entryIn);
        } else if (name2.equals("META-INF/MANIFEST.MF")) {
            this.processManifest(name2, entryIn, entry.getTime());
        } else if (!this.resources.contains(mappedName)) {
            this.processResource(mappedName, entryIn, entry.getTime());
        }
    }

    private void processDirectory(String name2, boolean parentsOnly) throws IOException {
        String parentDirectory;
        int index = name2.lastIndexOf(47);
        if (index != -1 && !this.resources.contains(parentDirectory = name2.substring(0, index))) {
            this.processDirectory(parentDirectory, false);
        }
        if (parentsOnly) {
            return;
        }
        JarEntry entry = new JarEntry(name2 + "/");
        this.jarOut.putNextEntry(entry);
        this.resources.add(name2);
    }

    private void processManifest(String name2, InputStream entryIn, long lastModified) throws IOException {
        Manifest in = new Manifest(entryIn);
        Manifest out = new Manifest();
        out.getMainAttributes().putAll((Map<?, ?>)in.getMainAttributes());
        for (Map.Entry<String, Attributes> entry : in.getEntries().entrySet()) {
            Attributes outAttributes = new Attributes();
            for (Map.Entry<Object, Object> property : entry.getValue().entrySet()) {
                String key2 = property.getKey().toString();
                if (SIGNATURE_PROPERTY_PATTERN.matcher(key2).matches()) continue;
                outAttributes.put(property.getKey(), property.getValue());
            }
            out.getEntries().put(entry.getKey(), outAttributes);
        }
        JarEntry jarEntry = new JarEntry(name2);
        jarEntry.setTime(lastModified);
        this.jarOut.putNextEntry(jarEntry);
        out.write(this.jarOut);
        this.resources.add(name2);
    }

    private void processResource(String name2, InputStream entryIn, long lastModified) throws IOException {
        JarEntry jarEntry = new JarEntry(name2);
        jarEntry.setTime(lastModified);
        this.jarOut.putNextEntry(jarEntry);
        JarRelocatorTask.copy(entryIn, this.jarOut);
        this.resources.add(name2);
    }

    private void processClass(String name2, InputStream entryIn) throws IOException {
        ClassReader classReader = new ClassReader(entryIn);
        ClassWriter classWriter = new ClassWriter(0);
        RelocatingClassVisitor classVisitor = new RelocatingClassVisitor(classWriter, this.remapper, name2);
        try {
            classReader.accept(classVisitor, 8);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error processing class " + name2, e);
        }
        byte[] renamedClass = classWriter.toByteArray();
        String mappedName = this.remapper.map(name2.substring(0, name2.indexOf(46)));
        this.jarOut.putNextEntry(new JarEntry(mappedName + ".class"));
        this.jarOut.write(renamedClass);
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = from.read(buf)) != -1) {
            to.write(buf, 0, n);
        }
    }
}

