/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.library.jarrelocator;

import cn.inrhor.imipetcore.taboolib.library.asm.commons.Remapper;
import cn.inrhor.imipetcore.taboolib.library.jarrelocator.Relocation;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RelocatingRemapper
extends Remapper {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+);");
    private final Collection<Relocation> rules;

    RelocatingRemapper(Collection<Relocation> rules) {
        this.rules = rules;
    }

    @Override
    public Object mapValue(Object object) {
        String relocatedName;
        if (object instanceof String && (relocatedName = this.relocate((String)object, true)) != null) {
            return relocatedName;
        }
        return super.mapValue(object);
    }

    @Override
    public String map(String name2) {
        String relocatedName = this.relocate(name2, false);
        if (relocatedName != null) {
            return relocatedName;
        }
        return super.map(name2);
    }

    private String relocate(String name2, boolean isClass) {
        String prefix = "";
        String suffix = "";
        Matcher m = CLASS_PATTERN.matcher(name2);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            suffix = ";";
            name2 = m.group(2);
        }
        for (Relocation r : this.rules) {
            if (isClass && r.canRelocateClass(name2)) {
                return prefix + r.relocateClass(name2) + suffix;
            }
            if (!r.canRelocatePath(name2)) continue;
            return prefix + r.relocatePath(name2) + suffix;
        }
        return null;
    }
}

