/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.library.kether;

import cn.inrhor.imipetcore.taboolib.library.kether.LoadError;

public abstract class AbstractStringReader {
    protected final char[] content;
    protected int index = 0;
    protected int mark = 0;

    public AbstractStringReader(char[] content) {
        this.content = content;
    }

    public AbstractStringReader(char[] content, int index, int mark) {
        this.content = content;
        this.index = index;
        this.mark = mark;
    }

    public char peek() {
        if (this.index < this.content.length) {
            return this.content[this.index];
        }
        throw LoadError.EOF.create(new Object[0]);
    }

    public char peek(int n) {
        if (this.index + n < this.content.length) {
            return this.content[this.index + n];
        }
        throw LoadError.EOF.create(new Object[0]);
    }

    public boolean hasNext() {
        this.skipBlank();
        return this.index < this.content.length;
    }

    public void mark() {
        this.mark = this.index;
    }

    public void reset() {
        this.index = this.mark;
    }

    public String nextToken() {
        if (!this.hasNext()) {
            throw LoadError.EOF.create(new Object[0]);
        }
        int begin = this.index;
        while (this.index < this.content.length && !Character.isWhitespace(this.content[this.index])) {
            ++this.index;
        }
        return new String(this.content, begin, this.index - begin);
    }

    protected void skip(int n) {
        this.index += n;
    }

    protected void skipBlank() {
        while (this.index < this.content.length) {
            if (Character.isWhitespace(this.content[this.index])) {
                ++this.index;
                continue;
            }
            if (this.index + 1 >= this.content.length || this.content[this.index] != '/' || this.content[this.index + 1] != '/') break;
            while (this.index < this.content.length && this.content[this.index] != '\n' && this.content[this.index] != '\r') {
                ++this.index;
            }
        }
    }

    protected void expect(String value) {
        String element = this.nextToken();
        if (!element.equals(value)) {
            this.failExpect(value, element);
        }
    }

    protected void failExpect(String expect, String got) {
        throw LoadError.NOT_MATCH.create(expect, got);
    }

    public char[] getContent() {
        return this.content;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMark() {
        return this.mark;
    }
}

