/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.library.kether;

import java.util.Objects;

public class ExitStatus {
    private static final ExitStatus PAUSED = new ExitStatus(true, false, 0L);
    private final boolean running;
    private final boolean waiting;
    private final long startTime;

    public ExitStatus(boolean running, boolean waiting, long startTime) {
        this.running = running;
        this.waiting = waiting;
        this.startTime = startTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExitStatus that = (ExitStatus)o;
        return this.isRunning() == that.isRunning() && this.isWaiting() == that.isWaiting() && this.getStartTime() == that.getStartTime();
    }

    public int hashCode() {
        return Objects.hash(this.isRunning(), this.isWaiting(), this.getStartTime());
    }

    public String toString() {
        return "ExitStatus{running=" + this.running + ", waiting=" + this.waiting + ", startTime=" + this.startTime + '}';
    }

    public static ExitStatus success() {
        return new ExitStatus(false, false, 0L);
    }

    public static ExitStatus paused() {
        return PAUSED;
    }

    public static ExitStatus cooldown(long timeout) {
        return new ExitStatus(true, true, System.currentTimeMillis() + timeout);
    }
}

