/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.module.nms.i18n;

import cn.inrhor.imipetcore.taboolib.common.env.RuntimeResource;
import cn.inrhor.imipetcore.taboolib.common.env.RuntimeResources;
import cn.inrhor.imipetcore.taboolib.module.nms.ItemTag;
import cn.inrhor.imipetcore.taboolib.module.nms.MinecraftVersion;
import cn.inrhor.imipetcore.taboolib.module.nms.NMSI18nKt;
import cn.inrhor.imipetcore.taboolib.module.nms.NMSItemTagKt;
import cn.inrhor.imipetcore.taboolib.module.nms.i18n.I18nBase;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RuntimeResources(value={@RuntimeResource(value="https://skymc.oss-cn-shanghai.aliyuncs.com/taboolib/resources/i18n_high_zh_CN.yml", hash="3aa002f314ac0768b00daa3563c08da9b5c674c5", zip=true), @RuntimeResource(value="https://skymc.oss-cn-shanghai.aliyuncs.com/taboolib/resources/i18n_low_zh_CN.yml", hash="476754933e2e486048f39726b822f24447d60ecb", zip=true)})
public class I18nLegacy
extends I18nBase {
    public static final I18nLegacy INSTANCE = new I18nLegacy();
    private static FileConfiguration lang;

    @Override
    public void init() {
        lang = YamlConfiguration.loadConfiguration((File)this.getLocaleFile());
    }

    @Override
    @NotNull
    public String getName(Player player, @NotNull Entity entity) {
        return Objects.requireNonNull(lang.getString(NMSI18nKt.getInternalName(entity).replace(".", "_"), entity.getName()));
    }

    @Override
    @NotNull
    public String getName(Player player, @NotNull ItemStack itemStack2) {
        String spawnEggType;
        ItemMeta itemMeta = itemStack2.getItemMeta();
        if (itemMeta instanceof BookMeta && ((BookMeta)itemMeta).getTitle() != null) {
            return Objects.requireNonNull(((BookMeta)itemMeta).getTitle());
        }
        if (MinecraftVersion.INSTANCE.getMajor() < 3) {
            if (itemStack2.getType().name().equals("MONSTER_EGG")) {
                ItemTag itemTag = NMSItemTagKt.getItemTag(itemStack2);
                if (itemTag.containsKey("EntityTag")) {
                    return lang.getString("item_monsterPlacer_name") + " " + lang.getString("entity_" + itemTag.get("EntityTag").asCompound().get("id").asString() + "_name");
                }
                return Objects.requireNonNull(lang.getString("item_monsterPlacer_name"));
            }
        } else if (MinecraftVersion.INSTANCE.getMajor() < 5 && itemMeta instanceof SpawnEggMeta && (spawnEggType = lang.getString("entity_" + ((SpawnEggMeta)itemMeta).getSpawnedType().getEntityClass().getSimpleName().replace(".", "_") + "_name")) != null) {
            return lang.getString(NMSI18nKt.getInternalName(itemStack2).replace(".", "_"), itemStack2.getType().name().toLowerCase(Locale.getDefault()).replace("_", "")) + " " + spawnEggType;
        }
        if (itemStack2.getType().equals((Object)Material.AIR)) {
            return Objects.requireNonNull(lang.getString("item_air"));
        }
        return Objects.requireNonNull(lang.getString(NMSI18nKt.getInternalName(itemStack2).replace(".", "_"), itemStack2.getType().name().toLowerCase(Locale.getDefault()).replace("_", "")));
    }

    @Override
    @NotNull
    public String getName(@Nullable Player player, @NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    @Override
    @NotNull
    public String getName(@Nullable Player player, @NotNull PotionEffectType potionEffectType) {
        return potionEffectType.getName();
    }

    private File getLocaleFile() {
        if (MinecraftVersion.INSTANCE.getMajor() >= 5) {
            return new File("assets/3a/3aa002f314ac0768b00daa3563c08da9b5c674c5");
        }
        return new File("assets/47/476754933e2e486048f39726b822f24447d60ecb");
    }
}

