/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.standard;

import cc.trixey.invero.common.adventure.adventure.text.format.TextColor;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.Context;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Tag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.standard.ColorTagResolver;
import cc.trixey.invero.common.adventure.adventure.util.ShadyPines;
import cc.trixey.invero.common.adventure.examination.ExaminableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GradientTag
extends AbstractColorChangingTag {
    private static final String GRADIENT = "gradient";
    static final TagResolver RESOLVER = TagResolver.resolver("gradient", GradientTag::create);
    private int index = 0;
    private int colorIndex = 0;
    private float factorStep = 0.0f;
    private final TextColor[] colors;
    private float phase;
    private final boolean negativePhase;

    static Tag create(ArgumentQueue args, Context ctx) {
        List<TextColor> textColors;
        float phase = 0.0f;
        if (args.hasNext()) {
            textColors = new ArrayList();
            while (args.hasNext()) {
                OptionalDouble possiblePhase;
                Tag.Argument arg = args.pop();
                if (!args.hasNext() && (possiblePhase = arg.asDouble()).isPresent()) {
                    phase = (float)possiblePhase.getAsDouble();
                    if (!(phase < -1.0f) && !(phase > 1.0f)) break;
                    throw ctx.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(phase)), args);
                }
                TextColor parsedColor = ColorTagResolver.resolveColor(arg.value(), ctx);
                textColors.add(parsedColor);
            }
            if (textColors.size() < 2) {
                throw ctx.newException("Invalid gradient, not enough colors. Gradients must have at least two colors.", args);
            }
        } else {
            textColors = Collections.emptyList();
        }
        return new GradientTag(phase, textColors);
    }

    private GradientTag(float phase, List<TextColor> colors) {
        if (phase < 0.0f) {
            this.negativePhase = true;
            this.phase = 1.0f + phase;
            Collections.reverse(colors);
        } else {
            this.negativePhase = false;
            this.phase = phase;
        }
        this.colors = colors.isEmpty() ? new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)} : colors.toArray(new TextColor[0]);
    }

    @Override
    protected void init() {
        int sectorLength = this.size() / (this.colors.length - 1);
        if (sectorLength < 1) {
            sectorLength = 1;
        }
        this.factorStep = 1.0f / (float)(sectorLength + this.index);
        this.phase *= (float)sectorLength;
        this.index = 0;
    }

    @Override
    protected void advanceColor() {
        ++this.index;
        if (this.factorStep * (float)this.index > 1.0f) {
            ++this.colorIndex;
            this.index = 0;
        }
    }

    @Override
    protected TextColor color() {
        float factor = this.factorStep * ((float)this.index + this.phase);
        if (factor > 1.0f) {
            factor = 1.0f - (factor - 1.0f);
        }
        if (this.negativePhase && this.colors.length % 2 != 0) {
            return TextColor.lerp(factor, this.colors[this.colorIndex + 1], this.colors[this.colorIndex]);
        }
        return TextColor.lerp(factor, this.colors[this.colorIndex], this.colors[this.colorIndex + 1]);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GradientTag that = (GradientTag)other;
        return this.index == that.index && this.colorIndex == that.colorIndex && ShadyPines.equals(that.factorStep, this.factorStep) && this.phase == that.phase && Arrays.equals(this.colors, that.colors);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.index, this.colorIndex, Float.valueOf(this.factorStep), Float.valueOf(this.phase));
        result = 31 * result + Arrays.hashCode(this.colors);
        return result;
    }
}

