/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.standard;

import cc.trixey.invero.common.adventure.adventure.key.InvalidKeyException;
import cc.trixey.invero.common.adventure.adventure.key.Key;
import cc.trixey.invero.common.adventure.adventure.nbt.api.BinaryTagHolder;
import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.event.HoverEvent;
import cc.trixey.invero.common.adventure.adventure.text.format.Style;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.Context;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.ParsingException;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.serializer.StyleClaim;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Tag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverTag {
    private static final String HOVER = "hover";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("hover", HoverTag::create, StyleClaim.claim("hover", Style::hoverEvent, HoverTag::emit));

    private HoverTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String actionName = args.popOr("Hover event requires an action as its first argument").value();
        HoverEvent.Action<?> action = HoverEvent.Action.NAMES.value(actionName);
        ActionHandler<?> value2 = HoverTag.actionHandler(action);
        if (value2 == null) {
            throw ctx.newException("Don't know how to turn '" + args + "' into a hover event", args);
        }
        return Tag.styling(HoverEvent.hoverEvent(action, value2.parse(args, ctx)));
    }

    static void emit(HoverEvent<?> event, TokenEmitter emitter) {
        ActionHandler<?> handler2 = HoverTag.actionHandler(event.action());
        emitter.tag(HOVER).argument(HoverEvent.Action.NAMES.key(event.action()));
        handler2.emit(event.value(), emitter);
    }

    @Nullable
    static <V> ActionHandler<V> actionHandler(HoverEvent.Action<V> action) {
        ActionHandler<Component> ret = null;
        if (action == HoverEvent.Action.SHOW_TEXT) {
            ret = ShowText.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            ret = ShowItem.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            ret = ShowEntity.INSTANCE;
        }
        return ret;
    }

    @NotNull
    static String compactAsString(@NotNull Key key2) {
        if (key2.namespace().equals("minecraft")) {
            return key2.value();
        }
        return key2.asString();
    }

    static final class ShowEntity
    implements ActionHandler<HoverEvent.ShowEntity> {
        static final ShowEntity INSTANCE = new ShowEntity();

        private ShowEntity() {
        }

        @Override
        public @NotNull HoverEvent.ShowEntity parse(@NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
            try {
                Key key2 = Key.key(args.popOr("Show entity needs a type argument").value());
                UUID id2 = UUID.fromString(args.popOr("Show entity needs an entity UUID").value());
                if (args.hasNext()) {
                    Component name2 = ctx.deserialize(args.pop().value());
                    return HoverEvent.ShowEntity.of(key2, id2, name2);
                }
                return HoverEvent.ShowEntity.of(key2, id2);
            }
            catch (InvalidKeyException | IllegalArgumentException ex) {
                throw ctx.newException("Exception parsing show_entity hover", ex, args);
            }
        }

        @Override
        public void emit(HoverEvent.ShowEntity event, TokenEmitter emit) {
            emit.argument(HoverTag.compactAsString(event.type())).argument(event.id().toString());
            if (event.name() != null) {
                emit.argument(event.name());
            }
        }
    }

    static final class ShowItem
    implements ActionHandler<HoverEvent.ShowItem> {
        private static final ShowItem INSTANCE = new ShowItem();

        private ShowItem() {
        }

        @Override
        public @NotNull HoverEvent.ShowItem parse(@NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
            try {
                int count;
                Key key2 = Key.key(args.popOr("Show item hover needs at least an item ID").value());
                int n = count = args.hasNext() ? args.pop().asInt().orElseThrow(() -> ctx.newException("The count argument was not a valid integer")) : 1;
                if (args.hasNext()) {
                    return HoverEvent.ShowItem.of(key2, count, BinaryTagHolder.binaryTagHolder(args.pop().value()));
                }
                return HoverEvent.ShowItem.of(key2, count);
            }
            catch (InvalidKeyException | NumberFormatException ex) {
                throw ctx.newException("Exception parsing show_item hover", ex, args);
            }
        }

        @Override
        public void emit(HoverEvent.ShowItem event, TokenEmitter emit) {
            emit.argument(HoverTag.compactAsString(event.item()));
            if (event.count() != 1 || event.nbt() != null) {
                emit.argument(Integer.toString(event.count()));
                if (event.nbt() != null) {
                    emit.argument(event.nbt().string());
                }
            }
        }
    }

    static final class ShowText
    implements ActionHandler<Component> {
        private static final ShowText INSTANCE = new ShowText();

        private ShowText() {
        }

        @Override
        @NotNull
        public Component parse(@NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
            return ctx.deserialize(args.popOr("show_text action requires a message").value());
        }

        @Override
        public void emit(Component event, TokenEmitter emit) {
            emit.argument(event);
        }
    }

    static interface ActionHandler<V> {
        @NotNull
        public V parse(@NotNull ArgumentQueue var1, @NotNull Context var2) throws ParsingException;

        public void emit(V var1, TokenEmitter var2);
    }
}

