/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.common5;

import cc.trixey.invero.taboolib.common.Isolated;
import cc.trixey.invero.taboolib.common.TabooLibCommon;
import cc.trixey.invero.taboolib.common.platform.Platform;
import cc.trixey.invero.taboolib.common.platform.ProxyPlayer;

@Isolated
public class Level {
    public static void setTotalExperience(ProxyPlayer player2, int exp) {
        player2.setLevel(0);
        player2.setExp(0.0f);
        player2.giveExp(exp);
    }

    private static int getExpAtLevel(ProxyPlayer player2) {
        return Level.getExpAtLevel(player2.getLevel());
    }

    public static int getExpAtLevel(int level) {
        if (TabooLibCommon.getRunningPlatform() == Platform.NUKKIT) {
            if (level >= 30) {
                return 112 + (level - 30) * 9;
            }
            if (level >= 15) {
                return 37 + (level - 15) * 5;
            }
            return 7 + level * 2;
        }
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getExpToLevel(int level) {
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += Level.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getTotalExperience(ProxyPlayer player2) {
        int exp = Math.round((float)Level.getExpAtLevel(player2) * player2.getExp());
        int currentLevel = player2.getLevel();
        while (currentLevel > 0) {
            exp += Level.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getExpUntilNextLevel(ProxyPlayer player2) {
        int exp = Math.round((float)Level.getExpAtLevel(player2) * player2.getExp());
        int nextLevel = player2.getLevel();
        return Level.getExpAtLevel(nextLevel) - exp;
    }
}

