/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.kether;

import cc.trixey.invero.taboolib.library.kether.AbstractStringReader;
import cc.trixey.invero.taboolib.library.kether.ActionProperties;
import cc.trixey.invero.taboolib.library.kether.BlockReader;
import cc.trixey.invero.taboolib.library.kether.LoadError;
import cc.trixey.invero.taboolib.library.kether.ParsedAction;
import cc.trixey.invero.taboolib.library.kether.QuestAction;
import cc.trixey.invero.taboolib.library.kether.QuestActionParser;
import cc.trixey.invero.taboolib.library.kether.QuestReader;
import cc.trixey.invero.taboolib.library.kether.QuestService;
import cc.trixey.invero.taboolib.library.kether.TokenBlock;
import cc.trixey.invero.taboolib.module.kether.Kether;
import cc.trixey.invero.taboolib.module.kether.action.ActionGet;
import cc.trixey.invero.taboolib.module.kether.action.ActionLiteral;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleReader
extends AbstractStringReader
implements QuestReader {
    protected final List<String> namespace;
    protected final QuestService<?> service;
    protected final BlockReader blockParser;

    public SimpleReader(QuestService<?> service, BlockReader reader, List<String> namespace2) {
        super(reader.content);
        this.service = service;
        this.blockParser = reader;
        this.index = reader.index;
        this.namespace = new ArrayList<String>(namespace2);
        this.namespace.add("kether");
    }

    @Override
    public String nextToken() {
        return this.nextTokenBlock().getToken();
    }

    @NotNull
    public TokenBlock nextTokenBlock() {
        this.skipBlank();
        switch (this.peek()) {
            case '\"': {
                int i;
                int cnt = 0;
                while (this.peek() == '\"') {
                    ++cnt;
                    this.skip(1);
                }
                int met = 0;
                for (i = this.index; i < this.content.length; ++i) {
                    if (this.content[i] == '\"') {
                        ++met;
                        continue;
                    }
                    if (met >= cnt) break;
                    met = 0;
                }
                if (met < cnt) {
                    throw LoadError.STRING_NOT_CLOSE.create(cnt);
                }
                String ret = new String(this.content, this.index, i - cnt - this.index);
                this.index = i;
                return new TokenBlock(ret, true);
            }
            case '\'': {
                this.skip(1);
                int i = this.index;
                while (this.peek() != '\'') {
                    this.skip(1);
                }
                String ret = new String(this.content, i, this.index - i);
                this.skip(1);
                return new TokenBlock(ret, true);
            }
        }
        return new TokenBlock(super.nextToken(), false);
    }

    protected ParsedAction<?> nextAnonAction() {
        ParsedAction<?> parsedAction = this.blockParser.readAnonymousAction();
        parsedAction.set(ActionProperties.REQUIRE_FRAME, true);
        return parsedAction;
    }

    @Override
    public <T> ParsedAction<T> nextAction() {
        return this.nextAction(null);
    }

    @Override
    public <T> ParsedAction<T> nextAction(@Nullable String namespace2) {
        this.skipBlank();
        switch (this.peek()) {
            case '{': {
                this.blockParser.index = this.index;
                ParsedAction<?> action = this.nextAnonAction();
                this.index = this.blockParser.index;
                return action;
            }
            case '&': {
                this.skip(1);
                this.beforeParse();
                return this.wrap(new ActionGet(this.nextToken()));
            }
            case '*': {
                this.skip(1);
                this.beforeParse();
                return this.wrap(new ActionLiteral(this.nextToken()));
            }
        }
        String element = this.nextToken();
        ArrayList<String> ns = new ArrayList<String>(this.namespace);
        ns.add(namespace2);
        Optional<QuestActionParser> optional = this.service.getRegistry().getParser(element, ns);
        if (optional.isPresent()) {
            this.beforeParse();
            return this.wrap(optional.get().resolve(this));
        }
        if (Kether.INSTANCE.isAllowToleranceParser()) {
            this.beforeParse();
            return this.wrap(new ActionLiteral(element, true));
        }
        throw LoadError.UNKNOWN_ACTION.create(element);
    }

    protected void beforeParse() {
    }

    protected <T> ParsedAction<T> wrap(QuestAction<T> action) {
        return new ParsedAction<T>(action);
    }

    @Override
    public void expect(@NotNull String value2) {
        super.expect(value2);
    }

    public List<String> getNamespace() {
        return this.namespace;
    }

    public QuestService<?> getService() {
        return this.service;
    }

    public BlockReader getBlockParser() {
        return this.blockParser;
    }
}

