/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.configuration;

import cc.trixey.invero.taboolib.library.configuration.ConfigurationSection;
import cc.trixey.invero.taboolib.library.configuration.YamlConstructor;
import cc.trixey.invero.taboolib.library.configuration.YamlRepresenter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml_2_0.DumperOptions;
import org.yaml.snakeyaml_2_0.LoaderOptions;
import org.yaml.snakeyaml_2_0.Yaml;
import org.yaml.snakeyaml_2_0.comments.CommentLine;
import org.yaml.snakeyaml_2_0.comments.CommentType;
import org.yaml.snakeyaml_2_0.nodes.AnchorNode;
import org.yaml.snakeyaml_2_0.nodes.MappingNode;
import org.yaml.snakeyaml_2_0.nodes.Node;
import org.yaml.snakeyaml_2_0.nodes.NodeTuple;
import org.yaml.snakeyaml_2_0.nodes.SequenceNode;
import org.yaml.snakeyaml_2_0.nodes.Tag;

public class YamlCommentLoader {
    private final DumperOptions yamlDumperOptions;
    private final LoaderOptions yamlLoaderOptions;
    private final YamlConstructor constructor;
    private final YamlRepresenter representer;
    private final Yaml yaml;

    public YamlCommentLoader(DumperOptions yamlDumperOptions, LoaderOptions yamlLoaderOptions, YamlConstructor constructor2, YamlRepresenter representer, Yaml yaml) {
        this.yamlDumperOptions = yamlDumperOptions;
        this.yamlLoaderOptions = yamlLoaderOptions;
        this.constructor = constructor2;
        this.representer = representer;
        this.yaml = yaml;
    }

    public void adjustNodeComments(MappingNode node2) {
        Node firstNode;
        List lines;
        if (node2.getBlockComments() == null && !node2.getValue().isEmpty() && (lines = (firstNode = ((NodeTuple)node2.getValue().get(0)).getKeyNode()).getBlockComments()) != null) {
            int index = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (((CommentLine)lines.get(i)).getCommentType() != CommentType.BLANK_LINE) continue;
                index = i;
            }
            if (index != -1) {
                node2.setBlockComments(lines.subList(0, index + 1));
                firstNode.setBlockComments(lines.subList(index + 1, lines.size()));
            }
        }
    }

    public void fromNodeTree(@NotNull MappingNode input, @NotNull ConfigurationSection section) {
        this.constructor.flattenMapping(input);
        for (NodeTuple nodeTuple : input.getValue()) {
            Node key2 = nodeTuple.getKeyNode();
            String keyString = String.valueOf(this.constructor.construct(key2));
            Node value2 = nodeTuple.getValueNode();
            while (value2 instanceof AnchorNode) {
                value2 = ((AnchorNode)value2).getRealNode();
            }
            if (value2 instanceof MappingNode) {
                this.fromNodeTree((MappingNode)value2, section.createSection(keyString));
            } else {
                section.set(keyString, this.constructor.construct(value2));
            }
            List<String> commentLines = this.getCommentLines(key2.getBlockComments());
            if (!commentLines.isEmpty()) {
                section.setComments(keyString, commentLines);
            }
            if (value2 instanceof MappingNode || value2 instanceof SequenceNode) {
                section.addComments(keyString, this.getCommentLines(key2.getInLineComments()));
                continue;
            }
            section.addComments(keyString, this.getCommentLines(value2.getInLineComments()));
        }
    }

    public MappingNode toNodeTree(@NotNull ConfigurationSection section) {
        ArrayList<NodeTuple> nodeTuples = new ArrayList<NodeTuple>();
        for (Map.Entry<String, Object> entry : section.getValues(false).entrySet()) {
            Node key2 = this.representer.represent(entry.getKey());
            Object value2 = entry.getValue() instanceof ConfigurationSection ? this.toNodeTree((ConfigurationSection)entry.getValue()) : this.representer.represent(entry.getValue());
            List<CommentLine> commentLines = this.getCommentLines(section.getComments(entry.getKey()), CommentType.BLOCK);
            if (!commentLines.isEmpty()) {
                key2.setBlockComments(commentLines);
            }
            nodeTuples.add(new NodeTuple(key2, (Node)value2));
        }
        return new MappingNode(Tag.MAP, nodeTuples, DumperOptions.FlowStyle.BLOCK);
    }

    public List<String> getCommentLines(List<CommentLine> comments) {
        ArrayList<String> lines = new ArrayList<String>();
        if (comments != null) {
            for (CommentLine comment : comments) {
                if (comment.getCommentType() == CommentType.BLANK_LINE) {
                    lines.add(null);
                    continue;
                }
                String line = comment.getValue();
                line = line.startsWith(" ") ? line.substring(1) : line;
                lines.add(line);
            }
        }
        return lines;
    }

    public List<CommentLine> getCommentLines(List<String> comments, CommentType commentType) {
        ArrayList<CommentLine> lines = new ArrayList<CommentLine>();
        for (String comment : comments) {
            if (comment == null) {
                lines.add(new CommentLine(null, null, "", CommentType.BLANK_LINE));
                continue;
            }
            String line = comment;
            line = line.isEmpty() ? line : " " + line;
            lines.add(new CommentLine(null, null, line, commentType));
        }
        return lines;
    }
}

