/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.platform;

import cc.trixey.invero.taboolib.common.io.File1Kt;
import cc.trixey.invero.taboolib.common.platform.Awake;
import cc.trixey.invero.taboolib.common.platform.Platform;
import cc.trixey.invero.taboolib.common.platform.PlatformSide;
import cc.trixey.invero.taboolib.common.platform.Plugin;
import cc.trixey.invero.taboolib.common.platform.service.PlatformIO;
import cc.trixey.invero.taboolib.platform.BukkitPlugin;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin1810.Pair;
import kotlin1810.TuplesKt;
import kotlin1810.collections.ArraysKt;
import kotlin1810.collections.MapsKt;
import kotlin1810.io.ByteStreamsKt;
import kotlin1810.io.FilesKt;
import kotlin1810.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

@Awake
@PlatformSide(value={Platform.BUKKIT})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J%\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0019\"\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0013\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001fH\u0016\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0019\"\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\"\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0019\"\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006#"}, d2={"Lcc/trixey/invero/taboolib/platform/BukkitIO;", "Lcc/trixey/invero/taboolib/common/platform/service/PlatformIO;", "()V", "isPrimaryThread", "", "()Z", "plugin", "Lcc/trixey/invero/taboolib/platform/BukkitPlugin;", "getPlugin", "()Ltaboolib/platform/BukkitPlugin;", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginVersion", "getPluginVersion", "getDataFolder", "Ljava/io/File;", "getJarFile", "getPlatformData", "", "", "info", "", "message", "", "([Ljava/lang/Object;)V", "releaseResourceFile", "path", "replace", "server", "T", "()Ljava/lang/Object;", "severe", "warning", "platform-bukkit"})
public final class BukkitIO
implements PlatformIO {
    @NotNull
    public final BukkitPlugin getPlugin() {
        BukkitPlugin bukkitPlugin = BukkitPlugin.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bukkitPlugin), (String)"getInstance()");
        return bukkitPlugin;
    }

    @Override
    @NotNull
    public String getPluginId() {
        String string = this.getPlugin().getDescription().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.description.name");
        return string;
    }

    @Override
    @NotNull
    public String getPluginVersion() {
        String string = this.getPlugin().getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.description.version");
        return string;
    }

    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    public <T> T server() {
        return (T)Bukkit.getServer();
    }

    @Override
    public void info(Object ... message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])message);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.getPlugin().getLogger().info(it.toString());
        }
    }

    @Override
    public void severe(Object ... message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])message);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.getPlugin().getLogger().severe(it.toString());
        }
    }

    @Override
    public void warning(Object ... message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])message);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.getPlugin().getLogger().warning(it.toString());
        }
    }

    @Override
    @NotNull
    public File releaseResourceFile(@NotNull String path, boolean replace) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(this.getDataFolder(), path);
        if (file.exists() && !replace) {
            return file;
        }
        Object object = this.getPlugin().getResource(path);
        byte[] byArray2 = byArray = object == null ? null : ByteStreamsKt.readBytes((InputStream)object);
        if (byArray == null) {
            object = Intrinsics.stringPlus((String)"resource not found: ", (Object)path);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        FilesKt.writeBytes((File)File1Kt.newFile$default(file, false, false, 6, null), (byte[])byArray);
        return file;
    }

    @Override
    @NotNull
    public File getJarFile() {
        Object object;
        File file;
        Object object2 = BukkitPlugin.getPluginInstance();
        File file2 = file = object2 == null ? null : ((Plugin)object2).nativeJarFile();
        if (file == null) {
            object2 = this.getPlugin().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"plugin.file");
            object = object2;
        } else {
            object = file;
        }
        return object;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        Object object;
        File file;
        Object object2 = BukkitPlugin.getPluginInstance();
        File file2 = file = object2 == null ? null : ((Plugin)object2).nativeDataFolder();
        if (file == null) {
            object2 = this.getPlugin().getDataFolder();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"plugin.dataFolder");
            object = object2;
        } else {
            object = file;
        }
        return object;
    }

    @Override
    @NotNull
    public Map<String, Object> getPlatformData() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bukkitVersion", (Object)Bukkit.getVersion()), TuplesKt.to((Object)"bukkitName", (Object)Bukkit.getName()), TuplesKt.to((Object)"onlineMode", (Object)(Bukkit.getOnlineMode() ? 1 : 0))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

