/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.minimessage;

import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.ArgumentQueueImpl;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.ContextImpl;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.ParsingException;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.Token;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.TokenParser;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.TokenType;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.node.ElementNode;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.node.RootNode;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.node.TagNode;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.parser.node.ValueNode;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Inserting;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Modifying;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Tag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import cc.trixey.invero.common.adventure.examination.Examinable;
import cc.trixey.invero.common.adventure.examination.string.MultiLineStringExaminer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MiniMessageParser {
    final TagResolver tagResolver;

    MiniMessageParser() {
        this.tagResolver = TagResolver.standard();
    }

    MiniMessageParser(TagResolver tagResolver) {
        this.tagResolver = tagResolver;
    }

    @NotNull
    String escapeTokens(@NotNull ContextImpl context2) {
        StringBuilder sb = new StringBuilder(context2.message().length());
        this.escapeTokens(sb, context2);
        return sb.toString();
    }

    void escapeTokens(StringBuilder sb, @NotNull ContextImpl context2) {
        this.escapeTokens(sb, context2.message(), context2);
    }

    private void escapeTokens(StringBuilder sb, String richMessage, ContextImpl context2) {
        this.processTokens(sb, richMessage, context2, (token, builder) -> {
            builder.append('\\').append('<');
            if (token.type() == TokenType.CLOSE_TAG) {
                builder.append('/');
            }
            List<Token> childTokens = token.childTokens();
            for (int i = 0; i < childTokens.size(); ++i) {
                if (i != 0) {
                    builder.append(':');
                }
                this.escapeTokens((StringBuilder)builder, childTokens.get(i).get(richMessage).toString(), context2);
            }
            builder.append('>');
        });
    }

    @NotNull
    String stripTokens(@NotNull ContextImpl context2) {
        StringBuilder sb = new StringBuilder(context2.message().length());
        this.processTokens(sb, context2, (token, builder) -> {});
        return sb.toString();
    }

    private void processTokens(@NotNull StringBuilder sb, @NotNull ContextImpl context2, BiConsumer<Token, StringBuilder> tagHandler) {
        this.processTokens(sb, context2.message(), context2, tagHandler);
    }

    private void processTokens(@NotNull StringBuilder sb, @NotNull String richMessage, @NotNull ContextImpl context2, BiConsumer<Token, StringBuilder> tagHandler) {
        TagResolver combinedResolver = TagResolver.resolver(this.tagResolver, context2.extraTags());
        List<Token> root = TokenParser.tokenize(richMessage, true);
        block4: for (Token token : root) {
            switch (token.type()) {
                case TEXT: {
                    sb.append(richMessage, token.startIndex(), token.endIndex());
                    continue block4;
                }
                case OPEN_TAG: 
                case CLOSE_TAG: 
                case OPEN_CLOSE_TAG: {
                    if (token.childTokens().isEmpty()) {
                        sb.append(richMessage, token.startIndex(), token.endIndex());
                        continue block4;
                    }
                    String sanitized = TokenParser.TagProvider.sanitizePlaceholderName(token.childTokens().get(0).get(richMessage).toString());
                    if (combinedResolver.has(sanitized)) {
                        tagHandler.accept(token, sb);
                        continue block4;
                    }
                    sb.append(richMessage, token.startIndex(), token.endIndex());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported token type " + (Object)((Object)token.type()));
        }
    }

    @NotNull
    RootNode parseToTree(@NotNull ContextImpl context2) {
        TagResolver combinedResolver = TagResolver.resolver(this.tagResolver, context2.extraTags());
        String processedMessage = (String)context2.preProcessor().apply(context2.message());
        Consumer<String> debug = context2.debugOutput();
        if (debug != null) {
            debug.accept("Beginning parsing message ");
            debug.accept(processedMessage);
            debug.accept("\n");
        }
        TokenParser.TagProvider transformationFactory = debug != null ? (name2, args, token) -> {
            try {
                debug.accept("Attempting to match node '");
                debug.accept(name2);
                debug.accept("'");
                if (token != null) {
                    debug.accept(" at column ");
                    debug.accept(String.valueOf(token.startIndex()));
                }
                debug.accept("\n");
                @Nullable Tag transformation = combinedResolver.resolve(name2, new ArgumentQueueImpl(context2, args), context2);
                if (transformation == null) {
                    debug.accept("Could not match node '");
                    debug.accept(name2);
                    debug.accept("'\n");
                } else {
                    debug.accept("Successfully matched node '");
                    debug.accept(name2);
                    debug.accept("' to tag ");
                    debug.accept(transformation instanceof Examinable ? ((Examinable)((Object)transformation)).examinableName() : transformation.getClass().getName());
                    debug.accept("\n");
                }
                return transformation;
            }
            catch (ParsingException e2) {
                ParsingExceptionImpl impl;
                if (token != null && e2 instanceof ParsingExceptionImpl && (impl = (ParsingExceptionImpl)e2).tokens().length == 0) {
                    impl.tokens(new Token[]{token});
                }
                debug.accept("Could not match node '");
                debug.accept(name2);
                debug.accept("' - ");
                debug.accept(e2.getMessage());
                debug.accept("\n");
                return null;
            }
        } : (name2, args, token) -> {
            try {
                return combinedResolver.resolve(name2, new ArgumentQueueImpl(context2, args), context2);
            }
            catch (ParsingException ignored) {
                return null;
            }
        };
        Predicate<String> tagNameChecker = name2 -> {
            String sanitized = TokenParser.TagProvider.sanitizePlaceholderName(name2);
            return combinedResolver.has(sanitized);
        };
        String preProcessed = TokenParser.resolvePreProcessTags(processedMessage, transformationFactory);
        context2.message(preProcessed);
        RootNode root = TokenParser.parse(transformationFactory, tagNameChecker, preProcessed, processedMessage, context2.strict());
        if (debug != null) {
            debug.accept("Text parsed into element tree:\n");
            debug.accept(root.toString());
        }
        return root;
    }

    @NotNull
    Component parseFormat(@NotNull ContextImpl context2) {
        RootNode root = this.parseToTree(context2);
        return Objects.requireNonNull((Component)context2.postProcessor().apply(this.treeToComponent(root, context2)), "Post-processor must not return null");
    }

    @NotNull
    Component treeToComponent(@NotNull ElementNode node2, @NotNull ContextImpl context2) {
        Consumer<String> debug;
        Component comp = Component.empty();
        Tag tag = null;
        if (node2 instanceof ValueNode) {
            comp = Component.text(((ValueNode)node2).value());
        } else if (node2 instanceof TagNode) {
            TagNode tagNode = (TagNode)node2;
            tag = tagNode.tag();
            if (tag instanceof Modifying) {
                Modifying modTransformation = (Modifying)tag;
                this.visitModifying(modTransformation, tagNode, 0);
                modTransformation.postVisit();
            }
            if (tag instanceof Inserting) {
                comp = ((Inserting)tag).value();
            }
        }
        if (!node2.unsafeChildren().isEmpty()) {
            ArrayList<Component> children = new ArrayList<Component>(comp.children().size() + node2.children().size());
            children.addAll(comp.children());
            for (ElementNode child : node2.unsafeChildren()) {
                children.add(this.treeToComponent(child, context2));
            }
            comp = comp.children(children);
        }
        if (tag instanceof Modifying) {
            comp = this.handleModifying((Modifying)tag, comp, 0);
        }
        if ((debug = context2.debugOutput()) != null) {
            debug.accept("==========\ntreeToComponent \n");
            debug.accept(node2.toString());
            debug.accept("\n");
            debug.accept(comp.examine(MultiLineStringExaminer.simpleEscaping()).collect(Collectors.joining("\n")));
            debug.accept("\n==========\n");
        }
        return comp;
    }

    private void visitModifying(Modifying modTransformation, ElementNode node2, int depth) {
        modTransformation.visit(node2, depth);
        for (ElementNode child : node2.unsafeChildren()) {
            this.visitModifying(modTransformation, child, depth + 1);
        }
    }

    private Component handleModifying(Modifying modTransformation, Component current, int depth) {
        Component newComp = modTransformation.apply(current, depth);
        for (Component child : current.children()) {
            newComp = newComp.append(this.handleModifying(modTransformation, child, depth + 1));
        }
        return newComp;
    }
}

