/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.nms;

import cc.trixey.invero.taboolib.module.nms.ItemTagData;
import cc.trixey.invero.taboolib.module.nms.ItemTagList;
import cc.trixey.invero.taboolib.module.nms.ItemTagSerializer;
import cc.trixey.invero.taboolib.module.nms.ItemTagType;
import cc.trixey.invero.taboolib.module.nms.NMSItemTagKt;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemTag
extends ItemTagData
implements Map<String, ItemTagData> {
    private final Map<String, ItemTagData> value = Maps.newConcurrentMap();

    public ItemTag() {
        super(0);
        this.type = ItemTagType.COMPOUND;
        this.data = this;
    }

    public void saveTo(ItemStack item2) {
        item2.setItemMeta(NMSItemTagKt.setItemTag(item2, this).getItemMeta());
    }

    public String toJson() {
        return ItemTagSerializer.INSTANCE.serializeData(this).toString();
    }

    public String toJsonFormatted() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ItemTagSerializer.INSTANCE.serializeTag(this));
    }

    @Override
    public String toJsonSimplified() {
        return this.toJsonSimplified(0);
    }

    @Override
    public String toJsonSimplified(int index) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        this.value.forEach((? super K k, ? super V v) -> builder.append(this.copy("  ", index + 1)).append("\"").append((String)k).append("\"").append(": ").append(v.toJsonSimplified(index + 1)).append("\n"));
        builder.append(this.copy("  ", index)).append("}");
        return builder.toString();
    }

    public static ItemTag fromJson(String json2) {
        return ItemTag.fromJson(new JsonParser().parse(json2)).asCompound();
    }

    public static ItemTagData fromJson(JsonElement element) {
        return ItemTagSerializer.INSTANCE.deserializeData(element);
    }

    @Deprecated
    public String toLegacyJson() {
        return new Gson().toJson((Object)this);
    }

    @Deprecated
    public static ItemTag fromLegacyJson(String json2) {
        return ItemTag.fromLegacyJson(new JsonParser().parse(json2)).asCompound();
    }

    @Deprecated
    public static ItemTagData fromLegacyJson(JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject json2 = (JsonObject)element;
            if (json2.has("type") && json2.has("data") && json2.entrySet().size() == 2) {
                switch (ItemTagType.parse(json2.get("type").getAsString())) {
                    case BYTE: {
                        return new ItemTagData(json2.get("data").getAsByte());
                    }
                    case SHORT: {
                        return new ItemTagData(json2.get("data").getAsShort());
                    }
                    case INT: {
                        return new ItemTagData(json2.get("data").getAsInt());
                    }
                    case LONG: {
                        return new ItemTagData(json2.get("data").getAsLong());
                    }
                    case FLOAT: {
                        return new ItemTagData(json2.get("data").getAsFloat());
                    }
                    case DOUBLE: {
                        return new ItemTagData(json2.get("data").getAsDouble());
                    }
                    case STRING: {
                        return new ItemTagData(json2.get("data").getAsString());
                    }
                    case BYTE_ARRAY: {
                        JsonArray array = json2.get("data").getAsJsonArray();
                        byte[] bytes = new byte[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            bytes[i] = array.get(i).getAsByte();
                        }
                        return new ItemTagData(bytes);
                    }
                    case INT_ARRAY: {
                        JsonArray array = json2.get("data").getAsJsonArray();
                        int[] ints = new int[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            ints[i] = array.get(i).getAsInt();
                        }
                        return new ItemTagData(ints);
                    }
                }
                return new ItemTagData("error: " + element);
            }
            ItemTag compound = new ItemTag();
            for (Map.Entry elementEntry : json2.entrySet()) {
                compound.put((String)elementEntry.getKey(), ItemTag.fromLegacyJson((JsonElement)elementEntry.getValue()));
            }
            return compound;
        }
        if (element instanceof JsonArray) {
            ItemTagList list2 = new ItemTagList();
            for (JsonElement jsonElement : (JsonArray)element) {
                list2.add(ItemTag.fromLegacyJson(jsonElement));
            }
            return list2;
        }
        return new ItemTagData("error: " + element);
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.value.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.value.containsValue(value2);
    }

    @Override
    public ItemTagData get(Object key2) {
        return this.value.get(key2);
    }

    public ItemTagData getOrElse(String key2, ItemTagData base) {
        return this.value.getOrDefault(key2, base);
    }

    public ItemTagData getDeep(String key2) {
        ItemTagData value2 = this;
        for (String keyStr : key2.split("\\.")) {
            if ((value2 = value2.asCompound().get(keyStr)) != null) continue;
            return null;
        }
        return value2;
    }

    public ItemTagData getDeepOrElse(String key2, ItemTagData base) {
        return Optional.ofNullable(this.getDeep(key2)).orElse(base);
    }

    @Override
    public ItemTagData put(String key2, ItemTagData value2) {
        return this.value.put(key2, value2);
    }

    @Override
    public ItemTagData put(String key2, Object value2) {
        return this.value.put(key2, ItemTagData.toNBT(value2));
    }

    public ItemTagData putDeep(String key2, Object value2) {
        return this.putDeep(key2, ItemTagData.toNBT(value2));
    }

    public ItemTagData putDeep(String key2, ItemTagData value2) {
        String[] split;
        ItemTagData compound = this;
        for (String node2 : split = key2.split("\\.")) {
            if (node2.equalsIgnoreCase(split[split.length - 1])) {
                return ((ItemTag)compound).put(node2, value2);
            }
            ItemTagData temp = compound.asCompound().get(node2);
            if (temp == null) {
                temp = new ItemTag();
                compound.asCompound().put(node2, temp);
            }
            compound = temp;
        }
        return null;
    }

    public ItemTagData removeDeep(String key2) {
        String[] split;
        ItemTagData compound = this;
        for (String node2 : split = key2.split("\\.")) {
            if (node2.equalsIgnoreCase(split[split.length - 1])) {
                return compound.remove(node2);
            }
            ItemTagData temp = compound.asCompound().get(node2);
            if (temp == null) {
                return null;
            }
            compound = temp;
        }
        return null;
    }

    @Override
    public ItemTagData remove(Object key2) {
        return this.value.remove(key2);
    }

    @Override
    public void putAll(@NotNull Map m) {
        this.value.putAll(m);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    @NotNull
    public Set keySet() {
        return this.value.keySet();
    }

    @Override
    @NotNull
    public Collection values() {
        return this.value.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, ItemTagData>> entrySet() {
        return this.value.entrySet();
    }

    @Override
    public ItemTagData getOrDefault(Object key2, ItemTagData defaultValue) {
        return this.value.getOrDefault(String.valueOf(key2), defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super ItemTagData> action) {
        this.value.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super ItemTagData, ? extends ItemTagData> function) {
        this.value.replaceAll(function);
    }

    @Override
    public ItemTagData putIfAbsent(String key2, ItemTagData value2) {
        return this.value.putIfAbsent(key2, value2);
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        return this.value.remove(key2, value2);
    }

    @Override
    public boolean replace(String key2, ItemTagData oldValue, ItemTagData newValue) {
        return this.value.replace(key2, oldValue, newValue);
    }

    @Override
    public ItemTagData replace(String key2, ItemTagData value2) {
        return this.value.replace(key2, value2);
    }

    @Override
    public ItemTagData computeIfAbsent(String key2, @NotNull Function<? super String, ? extends ItemTagData> mappingFunction) {
        return this.value.computeIfAbsent(key2, mappingFunction);
    }

    @Override
    public ItemTagData computeIfPresent(String key2, @NotNull BiFunction<? super String, ? super ItemTagData, ? extends ItemTagData> remappingFunction) {
        return this.value.computeIfPresent(key2, remappingFunction);
    }

    @Override
    public ItemTagData compute(String key2, @NotNull BiFunction<? super String, ? super ItemTagData, ? extends ItemTagData> remappingFunction) {
        return this.value.compute(key2, remappingFunction);
    }

    @Override
    public ItemTagData merge(String key2, @NotNull ItemTagData value2, @NotNull BiFunction<? super ItemTagData, ? super ItemTagData, ? extends ItemTagData> remappingFunction) {
        return this.value.merge(key2, value2, remappingFunction);
    }

    @Override
    public String toString() {
        return NMS_UTILS.itemTagToString(this);
    }
}

