/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver;

import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Tag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.MappableResolver;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CachingTagResolver
implements TagResolver.WithoutArguments,
MappableResolver,
SerializableResolver {
    private static final Tag NULL_REPLACEMENT = () -> {
        throw new UnsupportedOperationException("no-op null tag");
    };
    private final Map<String, Tag> cache = new HashMap<String, Tag>();
    private final TagResolver.WithoutArguments resolver;

    CachingTagResolver(TagResolver.WithoutArguments resolver) {
        this.resolver = resolver;
    }

    private Tag query(@NotNull String key2) {
        return this.cache.computeIfAbsent(key2, k -> {
            @Nullable Tag result = this.resolver.resolve((String)k);
            return result == null ? NULL_REPLACEMENT : result;
        });
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name2) {
        Tag potentialValue = this.query(name2);
        return potentialValue == NULL_REPLACEMENT ? null : potentialValue;
    }

    @Override
    public boolean has(@NotNull String name2) {
        return this.query(name2) != NULL_REPLACEMENT;
    }

    @Override
    public boolean contributeToMap(@NotNull Map<String, Tag> map2) {
        if (this.resolver instanceof MappableResolver) {
            return ((MappableResolver)((Object)this.resolver)).contributeToMap(map2);
        }
        return false;
    }

    @Override
    public void handle(@NotNull Component serializable, @NotNull ClaimConsumer consumer) {
        if (this.resolver instanceof SerializableResolver) {
            ((SerializableResolver)((Object)this.resolver)).handle(serializable, consumer);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CachingTagResolver)) {
            return false;
        }
        CachingTagResolver that = (CachingTagResolver)other;
        return Objects.equals(this.resolver, that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }
}

