/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver;

import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.Tag;
import cc.trixey.invero.common.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class Formatter {
    private Formatter() {
    }

    @NotNull
    public static TagResolver number(@NotNull String key2, @NotNull Number number) {
        return TagResolver.resolver(key2, (argumentQueue, context2) -> {
            NumberFormat decimalFormat;
            if (argumentQueue.hasNext()) {
                String locale = argumentQueue.pop().value();
                if (argumentQueue.hasNext()) {
                    String format = argumentQueue.pop().value();
                    decimalFormat = new DecimalFormat(format, new DecimalFormatSymbols(Locale.forLanguageTag(locale)));
                } else {
                    decimalFormat = locale.contains(".") ? new DecimalFormat(locale, DecimalFormatSymbols.getInstance()) : DecimalFormat.getInstance(Locale.forLanguageTag(locale));
                }
            } else {
                decimalFormat = DecimalFormat.getInstance();
            }
            return Tag.inserting(context2.deserialize(decimalFormat.format(number)));
        });
    }

    @NotNull
    public static TagResolver date(@NotNull String key2, @NotNull TemporalAccessor time) {
        return TagResolver.resolver(key2, (argumentQueue, context2) -> {
            String format = argumentQueue.popOr("Format expected.").value();
            return Tag.inserting(context2.deserialize(DateTimeFormatter.ofPattern(format).format(time)));
        });
    }

    @NotNull
    public static TagResolver choice(@NotNull String key2, Number number) {
        return TagResolver.resolver(key2, (argumentQueue, context2) -> {
            String format = argumentQueue.popOr("Format expected.").value();
            ChoiceFormat choiceFormat = new ChoiceFormat(format);
            return Tag.inserting(context2.deserialize(choiceFormat.format(number)));
        });
    }
}

