/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.renderer;

import cc.trixey.invero.common.adventure.adventure.text.BlockNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.EntityNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.KeybindComponent;
import cc.trixey.invero.common.adventure.adventure.text.NBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.ScoreComponent;
import cc.trixey.invero.common.adventure.adventure.text.SelectorComponent;
import cc.trixey.invero.common.adventure.adventure.text.StorageNBTComponent;
import cc.trixey.invero.common.adventure.adventure.text.TextComponent;
import cc.trixey.invero.common.adventure.adventure.text.TranslatableComponent;
import cc.trixey.invero.common.adventure.adventure.text.renderer.ComponentRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractComponentRenderer<C>
implements ComponentRenderer<C> {
    @Override
    @NotNull
    public Component render(@NotNull Component component, @NotNull C context2) {
        if (component instanceof TextComponent) {
            return this.renderText((TextComponent)component, context2);
        }
        if (component instanceof TranslatableComponent) {
            return this.renderTranslatable((TranslatableComponent)component, context2);
        }
        if (component instanceof KeybindComponent) {
            return this.renderKeybind((KeybindComponent)component, context2);
        }
        if (component instanceof ScoreComponent) {
            return this.renderScore((ScoreComponent)component, context2);
        }
        if (component instanceof SelectorComponent) {
            return this.renderSelector((SelectorComponent)component, context2);
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                return this.renderBlockNbt((BlockNBTComponent)component, context2);
            }
            if (component instanceof EntityNBTComponent) {
                return this.renderEntityNbt((EntityNBTComponent)component, context2);
            }
            if (component instanceof StorageNBTComponent) {
                return this.renderStorageNbt((StorageNBTComponent)component, context2);
            }
        }
        return component;
    }

    @NotNull
    protected abstract Component renderBlockNbt(@NotNull BlockNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderEntityNbt(@NotNull EntityNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderStorageNbt(@NotNull StorageNBTComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderKeybind(@NotNull KeybindComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderScore(@NotNull ScoreComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderSelector(@NotNull SelectorComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderText(@NotNull TextComponent var1, @NotNull C var2);

    @NotNull
    protected abstract Component renderTranslatable(@NotNull TranslatableComponent var1, @NotNull C var2);
}

