/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.text.serializer.gson;

import cc.trixey.invero.common.adventure.adventure.key.Key;
import cc.trixey.invero.common.adventure.adventure.text.Component;
import cc.trixey.invero.common.adventure.adventure.text.event.HoverEvent;
import cc.trixey.invero.common.adventure.adventure.text.serializer.gson.SerializerFactory;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

final class ShowEntitySerializer
extends TypeAdapter<HoverEvent.ShowEntity> {
    static final String TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";
    private final Gson gson;

    static TypeAdapter<HoverEvent.ShowEntity> create(Gson gson) {
        return new ShowEntitySerializer(gson).nullSafe();
    }

    private ShowEntitySerializer(Gson gson) {
        this.gson = gson;
    }

    public HoverEvent.ShowEntity read(JsonReader in) throws IOException {
        in.beginObject();
        Key type2 = null;
        UUID id2 = null;
        Component name2 = null;
        while (in.hasNext()) {
            String fieldName = in.nextName();
            if (fieldName.equals(TYPE)) {
                type2 = (Key)this.gson.fromJson(in, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (fieldName.equals(ID)) {
                id2 = UUID.fromString(in.nextString());
                continue;
            }
            if (fieldName.equals(NAME)) {
                name2 = (Component)this.gson.fromJson(in, SerializerFactory.COMPONENT_TYPE);
                continue;
            }
            in.skipValue();
        }
        if (type2 == null || id2 == null) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        in.endObject();
        return HoverEvent.ShowEntity.of(type2, id2, name2);
    }

    public void write(JsonWriter out, HoverEvent.ShowEntity value2) throws IOException {
        out.beginObject();
        out.name(TYPE);
        this.gson.toJson((Object)value2.type(), SerializerFactory.KEY_TYPE, out);
        out.name(ID);
        out.value(value2.id().toString());
        @Nullable Component name2 = value2.name();
        if (name2 != null) {
            out.name(NAME);
            this.gson.toJson((Object)name2, SerializerFactory.COMPONENT_TYPE, out);
        }
        out.endObject();
    }
}

