/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.configuration;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml_2_0.DumperOptions;
import org.yaml.snakeyaml_2_0.LoaderOptions;
import org.yaml.snakeyaml_2_0.Yaml;
import org.yaml.snakeyaml_2_0.comments.CommentEventsCollector;
import org.yaml.snakeyaml_2_0.comments.CommentType;
import org.yaml.snakeyaml_2_0.constructor.BaseConstructor;
import org.yaml.snakeyaml_2_0.emitter.Emitable;
import org.yaml.snakeyaml_2_0.emitter.Emitter;
import org.yaml.snakeyaml_2_0.error.YAMLException;
import org.yaml.snakeyaml_2_0.nodes.Node;
import org.yaml.snakeyaml_2_0.representer.Representer;
import org.yaml.snakeyaml_2_0.serializer.Serializer;

public class BukkitYaml
extends Yaml {
    private static final Field events = BukkitYaml.getEmitterField("events");
    private static final Field blockCommentsCollector = BukkitYaml.getEmitterField("blockCommentsCollector");
    private static final Field inlineCommentsCollector = BukkitYaml.getEmitterField("inlineCommentsCollector");

    private static Field getEmitterField(String name2) {
        Field field = null;
        try {
            field = Emitter.class.getDeclaredField(name2);
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return field;
    }

    public BukkitYaml(@NotNull BaseConstructor constructor2, @NotNull Representer representer, @NotNull DumperOptions dumperOptions, @NotNull LoaderOptions loadingConfig) {
        super(constructor2, representer, dumperOptions, loadingConfig);
    }

    public void serialize(@NotNull Node node2, @NotNull Writer output) {
        Emitter emitter = new Emitter(output, this.dumperOptions);
        if (events != null && blockCommentsCollector != null && inlineCommentsCollector != null) {
            ArrayDeque newEvents = new ArrayDeque(100);
            try {
                events.set(emitter, newEvents);
                blockCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, new CommentType[]{CommentType.BLANK_LINE, CommentType.BLOCK}));
                inlineCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, new CommentType[]{CommentType.IN_LINE}));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Could not update Yaml event queue", ex);
            }
        }
        Serializer serializer2 = new Serializer((Emitable)emitter, this.resolver, this.dumperOptions, null);
        try {
            serializer2.open();
            serializer2.serialize(node2);
            serializer2.close();
        }
        catch (IOException ex) {
            throw new YAMLException((Throwable)ex);
        }
    }
}

