/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.kether;

import cc.trixey.invero.taboolib.library.kether.LoadError;
import cc.trixey.invero.taboolib.library.kether.QuestService;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocalizedException
extends RuntimeException {
    private final LoadError error;
    private final String node;
    private final Object[] params;

    public LocalizedException(LoadError error, String node2, Object[] params) {
        this.error = error;
        this.node = node2;
        this.params = params;
    }

    public LoadError getError() {
        return this.error;
    }

    public String getNode() {
        return this.node;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public String getLocalizedMessage() {
        return QuestService.instance().getLocalizedText(this.node, this.params);
    }

    public Stream<LocalizedException> stream() {
        return Stream.of(this);
    }

    public LocalizedException then(LocalizedException e2) {
        return LocalizedException.batch(this, e2);
    }

    public static LocalizedException of(LoadError error, String node2, Object ... params) {
        return new LocalizedException(error, node2, params);
    }

    public static LocalizedException of(String node2, Object ... params) {
        return new LocalizedException(LoadError.UNKNOWN_ACTION, node2, params);
    }

    public static Supplier<LocalizedException> supply(String node2, Object ... params) {
        return () -> LocalizedException.of(node2, params);
    }

    public static LocalizedException batch(LocalizedException ... exceptions) {
        return new Concat(exceptions);
    }

    private static class Concat
    extends LocalizedException {
        private final LocalizedException[] exceptions;

        public Concat(LocalizedException ... exceptions) {
            super(LoadError.UNKNOWN_ACTION, exceptions[0].node, exceptions[0].params);
            this.exceptions = exceptions;
        }

        @Override
        public Stream<LocalizedException> stream() {
            return Arrays.stream(this.exceptions);
        }

        @Override
        public String getLocalizedMessage() {
            return this.stream().map(LocalizedException::getLocalizedMessage).collect(Collectors.joining("\n"));
        }

        @Override
        public LocalizedException then(LocalizedException e2) {
            LocalizedException[] arr = new LocalizedException[this.exceptions.length + 1];
            System.arraycopy(this.exceptions, 0, arr, 0, this.exceptions.length);
            arr[this.exceptions.length] = e2;
            return new Concat(arr);
        }
    }
}

