/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.kether;

import cc.trixey.invero.taboolib.library.kether.ExitStatus;
import cc.trixey.invero.taboolib.library.kether.ParsedAction;
import cc.trixey.invero.taboolib.library.kether.Quest;
import cc.trixey.invero.taboolib.library.kether.QuestFuture;
import cc.trixey.invero.taboolib.library.kether.QuestService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QuestContext {
    public static final String BASE_BLOCK = "main";

    public QuestService<? extends QuestContext> getService();

    public Quest getQuest();

    public void setExitStatus(ExitStatus var1);

    public Optional<ExitStatus> getExitStatus();

    public CompletableFuture<Object> runActions();

    public Executor getExecutor();

    public void terminate();

    public Frame rootFrame();

    public static interface VarTable {
        public <T> Optional<T> get(@NotNull String var1) throws CompletionException;

        default public <T> T getOrDefault(@NotNull String name2, T defaultValue) {
            Optional<T> o = this.get(name2);
            return o.orElse(defaultValue);
        }

        @Nullable
        default public <T> T getOrNull(@NotNull String name2) {
            Optional<Object> o = this.get(name2);
            return o.orElse(null);
        }

        public <T> Optional<QuestFuture<T>> getFuture(@NotNull String var1);

        public void set(@NotNull String var1, Object var2);

        public void remove(@NotNull String var1);

        public void clear();

        public <T> void set(@NotNull String var1, @NotNull ParsedAction<T> var2, @NotNull CompletableFuture<T> var3);

        public Set<String> keys();

        public Collection<Map.Entry<String, Object>> values();

        default public Map<String, Object> toMap() {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.values()) {
                map2.put(entry.getKey(), entry.getValue());
            }
            return map2;
        }

        public void initialize(@NotNull Frame var1);

        public void close();

        public VarTable parent();
    }

    public static interface Frame
    extends AutoCloseable {
        public String name();

        public QuestContext context();

        public Optional<ParsedAction<?>> currentAction();

        public List<Frame> children();

        default public Stream<Frame> walkFrames() {
            return this.walkFrames(Integer.MAX_VALUE);
        }

        default public Stream<Frame> walkFrames(int depth) {
            if (depth < 0) {
                return Stream.empty();
            }
            if (depth == 0) {
                return Stream.of(this);
            }
            Stream<Frame> acc = Stream.of(this);
            for (Frame it : this.children()) {
                Stream<Frame> frameStream = it.walkFrames(depth - 1);
                acc = Stream.concat(acc, frameStream);
            }
            return acc;
        }

        public Optional<Frame> parent();

        public void setNext(@NotNull ParsedAction<?> var1);

        public void setNext(@NotNull Quest.Block var1);

        public Frame newFrame(@NotNull String var1);

        public Frame newFrame(@NotNull ParsedAction<?> var1);

        public VarTable variables();

        public <T extends AutoCloseable> T addClosable(T var1);

        public <T> CompletableFuture<T> run();

        @Override
        public void close();

        public boolean isDone();
    }
}

