/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.nms;

import cc.trixey.invero.taboolib.common.platform.function.IOKt;
import cc.trixey.invero.taboolib.module.nms.ItemTag;
import cc.trixey.invero.taboolib.module.nms.ItemTagList;
import cc.trixey.invero.taboolib.module.nms.ItemTagType;
import cc.trixey.invero.taboolib.module.nms.MinecraftServerUtilKt;
import cc.trixey.invero.taboolib.module.nms.NMSGeneric;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.NumberConversions;

public class ItemTagData {
    protected static final NMSGeneric NMS_UTILS = MinecraftServerUtilKt.nmsProxy(NMSGeneric.class, "{name}Impl", new Object[0]);
    protected static final Pattern SHORT_PATTERN = Pattern.compile("\\d+s");
    protected ItemTagType type;
    protected Object data;

    public ItemTagData(String data) {
        this.type = ItemTagType.STRING;
        this.data = data;
    }

    public ItemTagData(byte data) {
        this.type = ItemTagType.BYTE;
        this.data = data;
    }

    public ItemTagData(byte[] data) {
        this.type = ItemTagType.BYTE_ARRAY;
        this.data = data;
    }

    public ItemTagData(int data) {
        this.type = ItemTagType.INT;
        this.data = data;
    }

    public ItemTagData(int[] data) {
        this.type = ItemTagType.INT_ARRAY;
        this.data = data;
    }

    public ItemTagData(double data) {
        this.type = ItemTagType.DOUBLE;
        this.data = data;
    }

    public ItemTagData(float data) {
        this.type = ItemTagType.FLOAT;
        this.data = Float.valueOf(data);
    }

    public ItemTagData(short data) {
        this.type = ItemTagType.SHORT;
        this.data = data;
    }

    public ItemTagData(long data) {
        this.type = ItemTagType.LONG;
        this.data = data;
    }

    public ItemTagData(ItemTag data) {
        this.type = ItemTagType.COMPOUND;
        this.data = data;
    }

    public ItemTagData(ItemTagList data) {
        this.type = ItemTagType.LIST;
        this.data = data;
    }

    public ItemTagData(ItemTagType type2, Object data) {
        this.type = type2;
        this.data = data;
    }

    public String toJsonSimplified() {
        return this.toJsonSimplified(0);
    }

    public String toJsonSimplified(int index) {
        return this.data instanceof String ? "\"" + this.data + "\"" : this.toString();
    }

    public Object unsafeData() {
        return this.data;
    }

    public String asString() {
        return String.valueOf(this.data);
    }

    public byte asByte() {
        return NumberConversions.toByte((Object)this.data);
    }

    public byte[] asByteArray() {
        return (byte[])this.data;
    }

    public int asInt() {
        return NumberConversions.toInt((Object)this.data);
    }

    public int[] asIntArray() {
        return (int[])this.data;
    }

    public double asDouble() {
        return NumberConversions.toDouble((Object)this.data);
    }

    public float asFloat() {
        return NumberConversions.toFloat((Object)this.data);
    }

    public short asShort() {
        return NumberConversions.toShort((Object)this.data);
    }

    public long asLong() {
        return NumberConversions.toLong((Object)this.data);
    }

    public ItemTag asCompound() {
        return (ItemTag)this.data;
    }

    public ItemTagList asList() {
        if (this.data instanceof ItemTagList) {
            return (ItemTagList)this.data;
        }
        return ItemTagList.of(new Object[]{this.data});
    }

    public ItemTagType getType() {
        return this.type;
    }

    public static ItemTagData toNBT(Object obj) {
        if (obj instanceof ItemTagData) {
            return (ItemTagData)obj;
        }
        if (obj instanceof String) {
            if (SHORT_PATTERN.matcher(obj.toString()).matches()) {
                return ItemTagData.toNBT(Short.valueOf(obj.toString().substring(0, obj.toString().length() - 1)));
            }
            return new ItemTagData((String)obj);
        }
        if (obj instanceof Integer) {
            return new ItemTagData((Integer)obj);
        }
        if (obj instanceof Double) {
            return new ItemTagData((Double)obj);
        }
        if (obj instanceof Float) {
            return new ItemTagData(((Float)obj).floatValue());
        }
        if (obj instanceof Short) {
            return new ItemTagData((Short)obj);
        }
        if (obj instanceof Long) {
            return new ItemTagData((Long)obj);
        }
        if (obj instanceof Byte) {
            return new ItemTagData((Byte)obj);
        }
        if (obj instanceof byte[]) {
            return new ItemTagData((byte[])obj);
        }
        if (obj instanceof int[]) {
            return new ItemTagData((int[])obj);
        }
        if (obj instanceof List) {
            return ItemTagData.translateList(new ItemTagList(), (List)obj);
        }
        if (obj instanceof Map) {
            ItemTag itemTag = new ItemTag();
            ((Map)obj).forEach((key2, value2) -> itemTag.put(key2.toString(), ItemTagData.toNBT(value2)));
            return itemTag;
        }
        if (obj instanceof ConfigurationSection) {
            ItemTag itemTag = new ItemTag();
            ((ConfigurationSection)obj).getValues(false).forEach((key2, value2) -> itemTag.put((String)key2, ItemTagData.toNBT(value2)));
            return itemTag;
        }
        return new ItemTagData("Not supported: " + obj);
    }

    public static ItemTagList translateList(ItemTagList itemTagListBase, List list2) {
        for (Object obj : list2) {
            ItemTagData base = ItemTagData.toNBT(obj);
            if (base == null) {
                IOKt.warning("Not supported: " + obj + " [" + obj.getClass().getSimpleName() + "]");
                continue;
            }
            itemTagListBase.add(base);
        }
        return itemTagListBase;
    }

    public static ItemTag translateSection(ItemTag nbt, ConfigurationSection section) {
        for (String key2 : section.getKeys(false)) {
            ItemTagData base;
            Object obj = section.get(key2);
            if (obj instanceof ConfigurationSection) {
                base = ItemTagData.translateSection(new ItemTag(), section.getConfigurationSection(key2));
            } else {
                base = ItemTagData.toNBT(obj);
                if (base == null) {
                    IOKt.warning("Invalid Type: " + obj + " [" + obj.getClass().getSimpleName() + "]");
                    continue;
                }
            }
            nbt.put(key2, base);
        }
        return nbt;
    }

    public String toString() {
        return NMS_UTILS.itemTagToString(this);
    }

    protected String copy(String text, int count) {
        return IntStream.range(0, count).mapToObj(i -> text).collect(Collectors.joining());
    }
}

