/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.math.fast;

import ia.sh.math.fast.CommonsAccurateMath$ExpFracTable;
import ia.sh.math.fast.CommonsAccurateMath$ExpIntTable;

final class CommonsAccurateMath {
    private static final long HEX_40000000 = 0x40000000L;
    private static final boolean RECOMPUTE_TABLES_AT_RUNTIME = false;
    static final int EXP_INT_TABLE_MAX_INDEX = 750;
    static final int EXP_INT_TABLE_LEN = 1500;
    static final int LN_MANT_LEN = 1024;
    static final int EXP_FRAC_TABLE_LEN = 1025;
    private static final double LOG_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);

    CommonsAccurateMath() {
    }

    private static double exp_(double d2, double d3, double[] dArray) {
        double d4;
        double d5;
        int n2;
        if (d2 < 0.0) {
            n2 = (int)(-d2);
            if (n2 > 746) {
                if (dArray != null) {
                    dArray[0] = 0.0;
                    dArray[1] = 0.0;
                }
                return 0.0;
            }
            if (n2 > 709) {
                double d6 = CommonsAccurateMath.exp_(d2 + 40.19140625, d3, dArray) / 2.8504009514401178E17;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 2.8504009514401178E17;
                    dArray[1] = dArray[1] / 2.8504009514401178E17;
                }
                return d6;
            }
            if (n2 == 709) {
                double d7 = CommonsAccurateMath.exp_(d2 + 1.494140625, d3, dArray) / 4.455505956692757;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 4.455505956692757;
                    dArray[1] = dArray[1] / 4.455505956692757;
                }
                return d7;
            }
            d5 = CommonsAccurateMath$ExpIntTable.EXP_INT_TABLE_A[750 - ++n2];
            d4 = CommonsAccurateMath$ExpIntTable.EXP_INT_TABLE_B[750 - n2];
            n2 = -n2;
        } else {
            n2 = (int)d2;
            if (n2 > 709) {
                if (dArray != null) {
                    dArray[0] = Double.POSITIVE_INFINITY;
                    dArray[1] = 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            d5 = CommonsAccurateMath$ExpIntTable.EXP_INT_TABLE_A[750 + n2];
            d4 = CommonsAccurateMath$ExpIntTable.EXP_INT_TABLE_B[750 + n2];
        }
        int n3 = (int)((d2 - (double)n2) * 1024.0);
        double d8 = CommonsAccurateMath$ExpFracTable.EXP_FRAC_TABLE_A[n3];
        double d9 = CommonsAccurateMath$ExpFracTable.EXP_FRAC_TABLE_B[n3];
        double d10 = d2 - ((double)n2 + (double)n3 / 1024.0);
        double d11 = 0.04168701738764507;
        d11 = d11 * d10 + 0.1666666505023083;
        d11 = d11 * d10 + 0.5000000000042687;
        d11 = d11 * d10 + 1.0;
        d11 = d11 * d10 + -3.940510424527919E-20;
        double d12 = d5 * d8;
        double d13 = d5 * d9 + d4 * d8 + d4 * d9;
        double d14 = d13 + d12;
        double d15 = d3 != 0.0 ? d14 * d3 * d11 + d14 * d3 + d14 * d11 + d13 + d12 : d14 * d11 + d13 + d12;
        if (dArray != null) {
            dArray[0] = d12;
            dArray[1] = d14 * d3 * d11 + d14 * d3 + d14 * d11 + d13;
        }
        return d15;
    }

    static double expm1(double d2) {
        return CommonsAccurateMath.expm1_(d2, null);
    }

    private static double expm1_(double d2, double[] dArray) {
        if (Double.isNaN(d2) || d2 == 0.0) {
            return d2;
        }
        if (d2 <= -1.0 || d2 >= 1.0) {
            double[] dArray2 = new double[2];
            CommonsAccurateMath.exp_(d2, 0.0, dArray2);
            if (d2 > 0.0) {
                return -1.0 + dArray2[0] + dArray2[1];
            }
            double d3 = -1.0 + dArray2[0];
            double d4 = -(d3 + 1.0 - dArray2[0]);
            return d3 + (d4 += dArray2[1]);
        }
        boolean bl2 = false;
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        }
        int n2 = (int)(d2 * 1024.0);
        double d5 = CommonsAccurateMath$ExpFracTable.EXP_FRAC_TABLE_A[n2] - 1.0;
        double d6 = CommonsAccurateMath$ExpFracTable.EXP_FRAC_TABLE_B[n2];
        double d7 = d5 + d6;
        d6 = -(d7 - d5 - d6);
        d5 = d7;
        d7 = d5 * 1.073741824E9;
        double d8 = d5 + d7 - d7;
        double d9 = d6 + (d5 - d8);
        double d10 = d2 - (double)n2 / 1024.0;
        double d11 = 0.008336750013465571;
        d11 = d11 * d10 + 0.041666663879186654;
        d11 = d11 * d10 + 0.16666666666745392;
        d11 = d11 * d10 + 0.49999999999999994;
        d11 *= d10;
        double d12 = d10;
        double d13 = d12 + (d11 *= d10);
        d11 = -(d13 - d12 - d11);
        d12 = d13;
        d13 = d12 * 1.073741824E9;
        d13 = d12 + d13 - d13;
        d11 += d12 - d13;
        d12 = d13;
        double d14 = d12 * d8;
        d13 = d14 + d12 * d9;
        double d15 = -(d13 - d14 - d12 * d9);
        d14 = d13;
        d13 = d14 + d11 * d8;
        d15 += -(d13 - d14 - d11 * d8);
        d14 = d13;
        d13 = d14 + d11 * d9;
        d15 += -(d13 - d14 - d11 * d9);
        d14 = d13;
        d13 = d14 + d8;
        d15 += -(d13 - d8 - d14);
        d14 = d13;
        d13 = d14 + d12;
        d15 += -(d13 - d14 - d12);
        d14 = d13;
        d13 = d14 + d9;
        d15 += -(d13 - d14 - d9);
        d14 = d13;
        d13 = d14 + d11;
        d15 += -(d13 - d14 - d11);
        d14 = d13;
        if (bl2) {
            double d16 = 1.0 + d14;
            double d17 = 1.0 / d16;
            double d18 = -(d16 - 1.0 - d14) + d15;
            double d19 = d14 * d17;
            d13 = d19 * 1.073741824E9;
            double d20 = d19 + d13 - d13;
            double d21 = d19 - d20;
            d13 = d16 * 1.073741824E9;
            d12 = d16 + d13 - d13;
            d11 = d16 - d12;
            d21 += (d14 - d12 * d20 - d12 * d21 - d11 * d20 - d11 * d21) * d17;
            d21 += d15 * d17;
            d21 += -d14 * d18 * d17 * d17;
            d14 = -d20;
            d15 = -d21;
        }
        if (dArray != null) {
            dArray[0] = d14;
            dArray[1] = d15;
        }
        return d14 + d15;
    }

    static double cosh(double d2) {
        if (Double.isNaN(d2)) {
            return d2;
        }
        if (d2 > 20.0) {
            if (d2 >= LOG_MAX_VALUE) {
                double d3 = Math.exp(0.5 * d2);
                return 0.5 * d3 * d3;
            }
            return 0.5 * Math.exp(d2);
        }
        if (d2 < -20.0) {
            if (d2 <= -LOG_MAX_VALUE) {
                double d4 = Math.exp(-0.5 * d2);
                return 0.5 * d4 * d4;
            }
            return 0.5 * Math.exp(-d2);
        }
        double[] dArray = new double[2];
        if (d2 < 0.0) {
            d2 = -d2;
        }
        CommonsAccurateMath.exp_(d2, 0.0, dArray);
        double d5 = dArray[0] + dArray[1];
        double d6 = -(d5 - dArray[0] - dArray[1]);
        double d7 = d5 * 1.073741824E9;
        double d8 = d5 + d7 - d7;
        double d9 = d5 - d8;
        double d10 = 1.0 / d5;
        d7 = d10 * 1.073741824E9;
        double d11 = d10 + d7 - d7;
        double d12 = d10 - d11;
        d12 += (1.0 - d8 * d11 - d8 * d12 - d9 * d11 - d9 * d12) * d10;
        d12 += -d6 * d10 * d10;
        d7 = d5 + d11;
        d6 += -(d7 - d5 - d11);
        d5 = d7;
        d7 = d5 + d12;
        d6 += -(d7 - d5 - d12);
        d5 = d7;
        double d13 = d5 + d6;
        return d13 *= 0.5;
    }

    static double sinh(double d2) {
        double d3;
        boolean bl2 = false;
        if (Double.isNaN(d2)) {
            return d2;
        }
        if (d2 > 20.0) {
            if (d2 >= LOG_MAX_VALUE) {
                double d4 = Math.exp(0.5 * d2);
                return 0.5 * d4 * d4;
            }
            return 0.5 * Math.exp(d2);
        }
        if (d2 < -20.0) {
            if (d2 <= -LOG_MAX_VALUE) {
                double d5 = Math.exp(-0.5 * d2);
                return -0.5 * d5 * d5;
            }
            return -0.5 * Math.exp(-d2);
        }
        if (d2 == 0.0) {
            return d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        }
        if (d2 > 0.25) {
            double[] dArray = new double[2];
            CommonsAccurateMath.exp_(d2, 0.0, dArray);
            double d6 = dArray[0] + dArray[1];
            double d7 = -(d6 - dArray[0] - dArray[1]);
            double d8 = d6 * 1.073741824E9;
            double d9 = d6 + d8 - d8;
            double d10 = d6 - d9;
            double d11 = 1.0 / d6;
            d8 = d11 * 1.073741824E9;
            double d12 = d11 + d8 - d8;
            double d13 = d11 - d12;
            d13 += (1.0 - d9 * d12 - d9 * d13 - d10 * d12 - d10 * d13) * d11;
            d13 += -d7 * d11 * d11;
            d12 = -d12;
            d13 = -d13;
            d8 = d6 + d12;
            d7 += -(d8 - d6 - d12);
            d6 = d8;
            d8 = d6 + d13;
            d7 += -(d8 - d6 - d13);
            d6 = d8;
            d3 = d6 + d7;
            d3 *= 0.5;
        } else {
            double[] dArray = new double[2];
            CommonsAccurateMath.expm1_(d2, dArray);
            double d14 = dArray[0] + dArray[1];
            double d15 = -(d14 - dArray[0] - dArray[1]);
            double d16 = 1.0 + d14;
            double d17 = 1.0 / d16;
            double d18 = -(d16 - 1.0 - d14) + d15;
            double d19 = d14 * d17;
            double d20 = d19 * 1.073741824E9;
            double d21 = d19 + d20 - d20;
            double d22 = d19 - d21;
            d20 = d16 * 1.073741824E9;
            double d23 = d16 + d20 - d20;
            double d24 = d16 - d23;
            d22 += (d14 - d23 * d21 - d23 * d22 - d24 * d21 - d24 * d22) * d17;
            d22 += d15 * d17;
            d22 += -d14 * d18 * d17 * d17;
            d20 = d14 + d21;
            d15 += -(d20 - d14 - d21);
            d14 = d20;
            d20 = d14 + d22;
            d15 += -(d20 - d14 - d22);
            d14 = d20;
            d3 = d14 + d15;
            d3 *= 0.5;
        }
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }

    static double tanh(double d2) {
        double d3;
        boolean bl2 = false;
        if (Double.isNaN(d2)) {
            return d2;
        }
        if (d2 > 20.0) {
            return 1.0;
        }
        if (d2 < -20.0) {
            return -1.0;
        }
        if (d2 == 0.0) {
            return d2;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        }
        if (d2 >= 0.5) {
            double[] dArray = new double[2];
            CommonsAccurateMath.exp_(d2 * 2.0, 0.0, dArray);
            double d4 = dArray[0] + dArray[1];
            double d5 = -(d4 - dArray[0] - dArray[1]);
            double d6 = -1.0 + d4;
            double d7 = -(d6 + 1.0 - d4);
            double d8 = d6 + d5;
            d7 += -(d8 - d6 - d5);
            d6 = d8;
            double d9 = 1.0 + d4;
            double d10 = -(d9 - 1.0 - d4);
            d8 = d9 + d5;
            d10 += -(d8 - d9 - d5);
            d9 = d8;
            d8 = d9 * 1.073741824E9;
            double d11 = d9 + d8 - d8;
            double d12 = d9 - d11;
            double d13 = d6 / d9;
            d8 = d13 * 1.073741824E9;
            double d14 = d13 + d8 - d8;
            double d15 = d13 - d14;
            d15 += (d6 - d11 * d14 - d11 * d15 - d12 * d14 - d12 * d15) / d9;
            d15 += d7 / d9;
            d3 = d14 + (d15 += -d10 * d6 / d9 / d9);
        } else {
            double[] dArray = new double[2];
            CommonsAccurateMath.expm1_(d2 * 2.0, dArray);
            double d16 = dArray[0] + dArray[1];
            double d17 = -(d16 - dArray[0] - dArray[1]);
            double d18 = d16;
            double d19 = d17;
            double d20 = 2.0 + d16;
            double d21 = -(d20 - 2.0 - d16);
            double d22 = d20 + d17;
            d21 += -(d22 - d20 - d17);
            d20 = d22;
            d22 = d20 * 1.073741824E9;
            double d23 = d20 + d22 - d22;
            double d24 = d20 - d23;
            double d25 = d18 / d20;
            d22 = d25 * 1.073741824E9;
            double d26 = d25 + d22 - d22;
            double d27 = d25 - d26;
            d27 += (d18 - d23 * d26 - d23 * d27 - d24 * d26 - d24 * d27) / d20;
            d27 += d19 / d20;
            d3 = d26 + (d27 += -d21 * d18 / d20 / d20);
        }
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }
}

