/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.math.fast;

final class JafamaFastMath {
    private static final boolean USE_TWO_POW_TAB = false;
    public static final double PI_SUP = Double.longBitsToDouble(Double.doubleToRawLongBits(Math.PI) + 1L);
    private static final double ONE_DIV_F2 = 0.5;
    private static final double ONE_DIV_F3 = 0.16666666666666666;
    private static final double ONE_DIV_F4 = 0.041666666666666664;
    private static final double TWO_POW_24 = JafamaFastMath.twoPow(24);
    private static final double TWO_POW_N24 = JafamaFastMath.twoPow(-24);
    private static final double TWO_POW_66 = JafamaFastMath.twoPow(66);
    private static final double TWO_POW_450 = JafamaFastMath.twoPow(450);
    private static final double TWO_POW_N450 = JafamaFastMath.twoPow(-450);
    private static final double TWO_POW_750 = JafamaFastMath.twoPow(750);
    private static final double TWO_POW_N750 = JafamaFastMath.twoPow(-750);
    private static final int MIN_DOUBLE_EXPONENT = -1074;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final double[] ONE_OVER_TWOPI_TAB = new double[]{2670176.0, 1.4390161E7, 346751.0, 644596.0, 8211767.0, 7354072.0, 1.0839631E7, 1106960.0, 8361048.0, 1.539883E7, 1.5816813E7, 1.317979E7, 9474932.0, 1.2059026E7, 4962946.0, 7627911.0, 4163450.0, 1.3053002E7, 6934458.0, 2133373.0, 4959953.0, 2177639.0, 1837485.0, 1564560.0, 5137525.0, 9330900.0, 1.3532455E7, 2168802.0, 1.5695434E7, 968702.0, 2490359.0, 8480259.0, 1.65017E7, 6477442.0, 1.0176475E7, 5087155.0, 1.3234882E7, 7197649.0, 9427367.0, 9960075.0, 6113774.0, 1.1664121E7, 8150735.0, 4312701.0, 1.4849188E7, 1.2229374E7, 1.4150727E7};
    private static final double TWOPI_TAB0 = Double.longBitsToDouble(4618760255839404032L);
    private static final double TWOPI_TAB1 = Double.longBitsToDouble(4509304086968926208L);
    private static final double TWOPI_TAB2 = Double.longBitsToDouble(4402346256551116800L);
    private static final double TWOPI_TAB3 = Double.longBitsToDouble(4294406894572797952L);
    private static final double TWOPI_TAB4 = Double.longBitsToDouble(4183874305429340160L);
    private static final double INVPIO2 = Double.longBitsToDouble(4603909380684499075L);
    private static final double PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
    private static final double PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
    private static final double INVTWOPI = INVPIO2 / 4.0;
    private static final double TWOPI_HI = 4.0 * PIO2_HI;
    private static final double TWOPI_LO = 4.0 * PIO2_LO;
    private static final double NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE = StrictMath.pow(2.0, 20.0) * (Math.PI * 2);
    private static final int SIN_COS_TABS_SIZE = (1 << JafamaFastMath.getTabSizePower(11)) + 1;
    private static final double SIN_COS_DELTA_HI = TWOPI_HI / (double)(SIN_COS_TABS_SIZE - 1);
    private static final double SIN_COS_DELTA_LO = TWOPI_LO / (double)(SIN_COS_TABS_SIZE - 1);
    private static final double SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
    private static final double[] sinTab = new double[SIN_COS_TABS_SIZE];
    private static final double[] cosTab = new double[SIN_COS_TABS_SIZE];
    private static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / SIN_COS_INDEXER * 0.99;
    private static final double ASIN_MAX_VALUE_FOR_TABS = StrictMath.sin(Math.toRadians(73.0));
    private static final int ASIN_TABS_SIZE = (1 << JafamaFastMath.getTabSizePower(13)) + 1;
    private static final double ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / (double)(ASIN_TABS_SIZE - 1);
    private static final double ASIN_INDEXER = 1.0 / ASIN_DELTA;
    private static final double[] asinTab = new double[ASIN_TABS_SIZE];
    private static final double[] asinDer1DivF1Tab = new double[ASIN_TABS_SIZE];
    private static final double[] asinDer2DivF2Tab = new double[ASIN_TABS_SIZE];
    private static final double[] asinDer3DivF3Tab = new double[ASIN_TABS_SIZE];
    private static final double[] asinDer4DivF4Tab = new double[ASIN_TABS_SIZE];
    private static final double ASIN_PIO2_HI = Double.longBitsToDouble(4609753056924675352L);
    private static final double ASIN_PIO2_LO = Double.longBitsToDouble(4364452196894661639L);
    private static final double ASIN_PS0 = Double.longBitsToDouble(4595172819793696085L);
    private static final double ASIN_PS1 = Double.longBitsToDouble(-4623835544539140227L);
    private static final double ASIN_PS2 = Double.longBitsToDouble(4596417465768494165L);
    private static final double ASIN_PS3 = Double.longBitsToDouble(-4637438604930937029L);
    private static final double ASIN_PS4 = Double.longBitsToDouble(4560439845004096136L);
    private static final double ASIN_PS5 = Double.longBitsToDouble(4540259411154564873L);
    private static final double ASIN_QS1 = Double.longBitsToDouble(-4610777653840302773L);
    private static final double ASIN_QS2 = Double.longBitsToDouble(4611733184086379208L);
    private static final double ASIN_QS3 = Double.longBitsToDouble(-4618997306433404583L);
    private static final double ASIN_QS4 = Double.longBitsToDouble(4590215604441354882L);
    private static final double ATAN_MAX_VALUE_FOR_TABS = StrictMath.tan(Math.toRadians(74.0));
    private static final int ATAN_TABS_SIZE = (1 << JafamaFastMath.getTabSizePower(12)) + 1;
    private static final double ATAN_DELTA = ATAN_MAX_VALUE_FOR_TABS / (double)(ATAN_TABS_SIZE - 1);
    private static final double ATAN_INDEXER = 1.0 / ATAN_DELTA;
    private static final double[] atanTab = new double[ATAN_TABS_SIZE];
    private static final double[] atanDer1DivF1Tab = new double[ATAN_TABS_SIZE];
    private static final double[] atanDer2DivF2Tab = new double[ATAN_TABS_SIZE];
    private static final double[] atanDer3DivF3Tab = new double[ATAN_TABS_SIZE];
    private static final double[] atanDer4DivF4Tab = new double[ATAN_TABS_SIZE];
    private static final double ATAN_HI3 = Double.longBitsToDouble(4609753056924675352L);
    private static final double ATAN_LO3 = Double.longBitsToDouble(4364452196894661639L);
    private static final double ATAN_AT0 = Double.longBitsToDouble(4599676419421066509L);
    private static final double ATAN_AT1 = Double.longBitsToDouble(-4626998257160492092L);
    private static final double ATAN_AT2 = Double.longBitsToDouble(4594314991288484863L);
    private static final double ATAN_AT3 = Double.longBitsToDouble(-4630701217362536847L);
    private static final double ATAN_AT4 = Double.longBitsToDouble(4591215095208222830L);
    private static final double ATAN_AT5 = Double.longBitsToDouble(-4633165035261879699L);
    private static final double ATAN_AT6 = Double.longBitsToDouble(4589464229703073105L);
    private static final double ATAN_AT7 = Double.longBitsToDouble(-4634804155249132134L);
    private static final double ATAN_AT8 = Double.longBitsToDouble(4587333258118041067L);
    private static final double ATAN_AT9 = Double.longBitsToDouble(-4637946461342241745L);
    private static final double ATAN_AT10 = Double.longBitsToDouble(4580351289466214929L);
    private static final double[] twoPowTab = null;

    static double cos(double d2) {
        if ((d2 = Math.abs(d2)) > SIN_COS_MAX_VALUE_FOR_INT_MODULO && (d2 = JafamaFastMath.remainderTwoPi(d2)) < 0.0) {
            d2 += Math.PI * 2;
        }
        int n2 = (int)(d2 * SIN_COS_INDEXER + 0.5);
        double d3 = d2 - (double)n2 * SIN_COS_DELTA_HI - (double)n2 * SIN_COS_DELTA_LO;
        double d4 = cosTab[n2 &= SIN_COS_TABS_SIZE - 2];
        double d5 = sinTab[n2];
        return d4 + d3 * (-d5 + d3 * (-d4 * 0.5 + d3 * (d5 * 0.16666666666666666 + d3 * d4 * 0.041666666666666664)));
    }

    static double asin(double d2) {
        boolean bl2;
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (d2 <= ASIN_MAX_VALUE_FOR_TABS) {
            int n2 = (int)(d2 * ASIN_INDEXER + 0.5);
            double d3 = d2 - (double)n2 * ASIN_DELTA;
            double d4 = asinTab[n2] + d3 * (asinDer1DivF1Tab[n2] + d3 * (asinDer2DivF2Tab[n2] + d3 * (asinDer3DivF3Tab[n2] + d3 * asinDer4DivF4Tab[n2])));
            return bl2 ? -d4 : d4;
        }
        if (d2 < 1.0) {
            double d5 = (1.0 - d2) * 0.5;
            double d6 = d5 * (ASIN_PS0 + d5 * (ASIN_PS1 + d5 * (ASIN_PS2 + d5 * (ASIN_PS3 + d5 * (ASIN_PS4 + d5 * ASIN_PS5)))));
            double d7 = 1.0 + d5 * (ASIN_QS1 + d5 * (ASIN_QS2 + d5 * (ASIN_QS3 + d5 * ASIN_QS4)));
            double d8 = Math.sqrt(d5);
            double d9 = d8 + d8 * (d6 / d7);
            double d10 = ASIN_PIO2_HI - (d9 + d9 - ASIN_PIO2_LO);
            return bl2 ? -d10 : d10;
        }
        if (d2 == 1.0) {
            return bl2 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Double.NaN;
    }

    static double acos(double d2) {
        return 1.5707963267948966 - JafamaFastMath.asin(d2);
    }

    static double atan(double d2) {
        boolean bl2;
        if (d2 < 0.0) {
            d2 = -d2;
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (d2 == 1.0) {
            return bl2 ? -0.7853981633974483 : 0.7853981633974483;
        }
        if (d2 <= ATAN_MAX_VALUE_FOR_TABS) {
            int n2 = (int)(d2 * ATAN_INDEXER + 0.5);
            double d3 = d2 - (double)n2 * ATAN_DELTA;
            double d4 = atanTab[n2] + d3 * (atanDer1DivF1Tab[n2] + d3 * (atanDer2DivF2Tab[n2] + d3 * (atanDer3DivF3Tab[n2] + d3 * atanDer4DivF4Tab[n2])));
            return bl2 ? -d4 : d4;
        }
        if (d2 < TWO_POW_66) {
            double d5 = -1.0 / d2;
            double d6 = d5 * d5;
            double d7 = d6 * d6;
            double d8 = d6 * (ATAN_AT0 + d7 * (ATAN_AT2 + d7 * (ATAN_AT4 + d7 * (ATAN_AT6 + d7 * (ATAN_AT8 + d7 * ATAN_AT10)))));
            double d9 = d7 * (ATAN_AT1 + d7 * (ATAN_AT3 + d7 * (ATAN_AT5 + d7 * (ATAN_AT7 + d7 * ATAN_AT9))));
            double d10 = ATAN_HI3 - (d5 * (d8 + d9) - ATAN_LO3 - d5);
            return bl2 ? -d10 : d10;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        return bl2 ? -1.5707963267948966 : 1.5707963267948966;
    }

    static double atan2(double d2, double d3) {
        if (d3 > 0.0) {
            if (d2 == 0.0) {
                return d2;
            }
            if (d3 == Double.POSITIVE_INFINITY) {
                return JafamaFastMath.atan2_pinf_yyy(d2);
            }
            return JafamaFastMath.atan(d2 / d3);
        }
        if (d3 < 0.0) {
            if (d2 == 0.0) {
                return (double)JafamaFastMath.signFromBit(d2) * Math.PI;
            }
            if (d3 == Double.NEGATIVE_INFINITY) {
                return JafamaFastMath.atan2_ninf_yyy(d2);
            }
            if (d2 > 0.0) {
                return 1.5707963267948966 + JafamaFastMath.atan(-d3 / d2);
            }
            if (d2 < 0.0) {
                return -1.5707963267948966 - JafamaFastMath.atan(d3 / d2);
            }
            return Double.NaN;
        }
        return JafamaFastMath.atan2_zeroOrNaN_yyy(d3, d2);
    }

    static double hypot(double d2, double d3) {
        double d4;
        d2 = Math.abs(d2);
        if ((d3 = Math.abs(d3)) < d2) {
            d4 = d2;
            d2 = d3;
            d3 = d4;
        } else if (!(d3 >= d2)) {
            if (d2 == Double.POSITIVE_INFINITY || d3 == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        if (d3 - d2 == d3) {
            return d3;
        }
        if (d2 > TWO_POW_450) {
            d2 *= TWO_POW_N750;
            d3 *= TWO_POW_N750;
            d4 = TWO_POW_750;
        } else if (d3 < TWO_POW_N450) {
            d2 *= TWO_POW_750;
            d3 *= TWO_POW_750;
            d4 = TWO_POW_N750;
        } else {
            d4 = 1.0;
        }
        return d4 * Math.sqrt(d2 * d2 + d3 * d3);
    }

    private JafamaFastMath() {
    }

    private static int getTabSizePower(int n2) {
        return n2;
    }

    private static long signFromBit(double d2) {
        return Double.doubleToRawLongBits(d2) >> 62 | 1L;
    }

    private static double twoPow(int n2) {
        if (n2 <= -1023) {
            if (n2 >= -1074) {
                return Double.longBitsToDouble(0x8000000000000L >> -(n2 + 1023));
            }
            return 0.0;
        }
        if (n2 > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble((long)(n2 + 1023) << 52);
    }

    private static double twoPowNormal(int n2) {
        return Double.longBitsToDouble((long)(n2 + 1023) << 52);
    }

    private static double atan2_pinf_yyy(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            return 0.7853981633974483;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return -0.7853981633974483;
        }
        if (d2 > 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return -0.0;
        }
        return Double.NaN;
    }

    private static double atan2_ninf_yyy(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            return 2.356194490192345;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return -2.356194490192345;
        }
        if (d2 > 0.0) {
            return Math.PI;
        }
        if (d2 < 0.0) {
            return -Math.PI;
        }
        return Double.NaN;
    }

    private static double atan2_zeroOrNaN_yyy(double d2, double d3) {
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                if (JafamaFastMath.signFromBit(d2) < 0L) {
                    return (double)JafamaFastMath.signFromBit(d3) * Math.PI;
                }
                return d3;
            }
            if (d3 > 0.0) {
                return 1.5707963267948966;
            }
            if (d3 < 0.0) {
                return -1.5707963267948966;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    private static double remainderTwoPi(double d2) {
        boolean bl2;
        if (d2 < 0.0) {
            bl2 = true;
            d2 = -d2;
        } else {
            bl2 = false;
        }
        if (d2 <= NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE) {
            double d3 = (int)(d2 * INVTWOPI + 0.5);
            double d4 = d2 - d3 * TWOPI_HI - d3 * TWOPI_LO;
            return bl2 ? -d4 : d4;
        }
        if (d2 < Double.POSITIVE_INFINITY) {
            long l2 = Double.doubleToRawLongBits(d2);
            long l3 = (l2 >> 52 & 0x7FFL) - 1046L;
            double d5 = Double.longBitsToDouble(l2 - (l3 << 52));
            double d6 = (int)d5;
            d5 = (d5 - d6) * TWO_POW_24;
            double d7 = (int)d5;
            double d8 = (d5 - d7) * TWO_POW_24;
            double d9 = JafamaFastMath.subRemainderTwoPi(d6, d7, d8, (int)l3, d8 == 0.0 ? 2 : 3);
            return bl2 ? -d9 : d9;
        }
        return Double.NaN;
    }

    private static double subRemainderTwoPi(double d2, double d3, double d4, int n2, int n3) {
        int n4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = 0.0;
        int n5 = n3 - 1;
        int n6 = (n2 - 3) / 24;
        int n7 = n2 - ((n6 << 4) + (n6 << 3)) - 24;
        int n8 = n6 + 4;
        if (n5 == 1) {
            d10 = n8 >= 0 ? ONE_OVER_TWOPI_TAB[n8] : 0.0;
            double d12 = n8 >= 1 ? ONE_OVER_TWOPI_TAB[n8 - 1] : 0.0;
            double d13 = n8 >= 2 ? ONE_OVER_TWOPI_TAB[n8 - 2] : 0.0;
            double d14 = n8 >= 3 ? ONE_OVER_TWOPI_TAB[n8 - 3] : 0.0;
            double d15 = n8 >= 4 ? ONE_OVER_TWOPI_TAB[n8 - 4] : 0.0;
            double d16 = n8 >= 5 ? ONE_OVER_TWOPI_TAB[n8 - 5] : 0.0;
            d9 = d2 * d15 + d3 * d16;
            d8 = d2 * d14 + d3 * d15;
            d7 = d2 * d13 + d3 * d14;
            d6 = d2 * d12 + d3 * d13;
            d5 = d2 * d10 + d3 * d12;
        } else {
            d11 = n8 >= 0 ? ONE_OVER_TWOPI_TAB[n8] : 0.0;
            d10 = n8 >= 1 ? ONE_OVER_TWOPI_TAB[n8 - 1] : 0.0;
            double d17 = n8 >= 2 ? ONE_OVER_TWOPI_TAB[n8 - 2] : 0.0;
            double d18 = n8 >= 3 ? ONE_OVER_TWOPI_TAB[n8 - 3] : 0.0;
            double d19 = n8 >= 4 ? ONE_OVER_TWOPI_TAB[n8 - 4] : 0.0;
            double d20 = n8 >= 5 ? ONE_OVER_TWOPI_TAB[n8 - 5] : 0.0;
            double d21 = n8 >= 6 ? ONE_OVER_TWOPI_TAB[n8 - 6] : 0.0;
            d9 = d2 * d19 + d3 * d20 + d4 * d21;
            d8 = d2 * d18 + d3 * d19 + d4 * d20;
            d7 = d2 * d17 + d3 * d18 + d4 * d19;
            d6 = d2 * d10 + d3 * d17 + d4 * d18;
            d5 = d2 * d11 + d3 * d10 + d4 * d17;
        }
        double d22 = d5;
        double d23 = (int)(TWO_POW_N24 * d22);
        int n9 = (int)(d22 - TWO_POW_24 * d23);
        d22 = d6 + d23;
        d23 = (int)(TWO_POW_N24 * d22);
        int n10 = (int)(d22 - TWO_POW_24 * d23);
        d22 = d7 + d23;
        d23 = (int)(TWO_POW_N24 * d22);
        int n11 = (int)(d22 - TWO_POW_24 * d23);
        d22 = d8 + d23;
        d23 = (int)(TWO_POW_N24 * d22);
        int n12 = (int)(d22 - TWO_POW_24 * d23);
        d22 = d9 + d23;
        double d24 = JafamaFastMath.twoPowNormal(n7);
        d22 = d22 * d24 % 8.0;
        d22 -= (double)((int)d22);
        int n13 = n7 > 0 ? (n12 &= 0xFFFFFF >> n7) >> 23 - n7 : (n7 == 0 ? n12 >> 23 : (d22 >= 0.5 ? 2 : 0));
        if (n13 > 0) {
            boolean bl2;
            if (n9 != 0) {
                bl2 = true;
                n9 = 0x1000000 - n9;
                n10 = 0xFFFFFF - n10;
                n11 = 0xFFFFFF - n11;
                n12 = 0xFFFFFF - n12;
            } else if (n10 != 0) {
                bl2 = true;
                n10 = 0x1000000 - n10;
                n11 = 0xFFFFFF - n11;
                n12 = 0xFFFFFF - n12;
            } else if (n11 != 0) {
                bl2 = true;
                n11 = 0x1000000 - n11;
                n12 = 0xFFFFFF - n12;
            } else if (n12 != 0) {
                bl2 = true;
                n12 = 0x1000000 - n12;
            } else {
                bl2 = false;
            }
            if (n7 > 0) {
                switch (n7) {
                    case 1: {
                        n12 &= 0x7FFFFF;
                        break;
                    }
                    case 2: {
                        n12 &= 0x3FFFFF;
                    }
                }
            }
            if (n13 == 2) {
                d22 = 1.0 - d22;
                if (bl2) {
                    d22 -= d24;
                }
            }
        }
        if (d22 == 0.0) {
            double d25;
            if (n5 == 1) {
                d11 = ONE_OVER_TWOPI_TAB[n6 + 5];
                d25 = d2 * d11 + d3 * d10;
            } else {
                double d26 = ONE_OVER_TWOPI_TAB[n6 + 5];
                d25 = d2 * d26 + d3 * d11 + d4 * d10;
            }
            d22 = d25;
            d23 = (int)(TWO_POW_N24 * d22);
            n9 = (int)(d22 - TWO_POW_24 * d23);
            d22 = d5 + d23;
            d23 = (int)(TWO_POW_N24 * d22);
            n10 = (int)(d22 - TWO_POW_24 * d23);
            d22 = d6 + d23;
            d23 = (int)(TWO_POW_N24 * d22);
            n11 = (int)(d22 - TWO_POW_24 * d23);
            d22 = d7 + d23;
            d23 = (int)(TWO_POW_N24 * d22);
            n12 = (int)(d22 - TWO_POW_24 * d23);
            d22 = d8 + d23;
            d23 = (int)(TWO_POW_N24 * d22);
            n4 = (int)(d22 - TWO_POW_24 * d23);
            d22 = d9 + d23;
            d22 = d22 * d24 % 8.0;
            d22 -= (double)((int)d22);
            n13 = n7 > 0 ? (n4 &= 0xFFFFFF >> n7) >> 23 - n7 : (n7 == 0 ? n4 >> 23 : (d22 >= 0.5 ? 2 : 0));
            if (n13 > 0) {
                if (n9 != 0) {
                    n9 = 0x1000000 - n9;
                    n10 = 0xFFFFFF - n10;
                    n11 = 0xFFFFFF - n11;
                    n12 = 0xFFFFFF - n12;
                    n4 = 0xFFFFFF - n4;
                } else if (n10 != 0) {
                    n10 = 0x1000000 - n10;
                    n11 = 0xFFFFFF - n11;
                    n12 = 0xFFFFFF - n12;
                    n4 = 0xFFFFFF - n4;
                } else if (n11 != 0) {
                    n11 = 0x1000000 - n11;
                    n12 = 0xFFFFFF - n12;
                    n4 = 0xFFFFFF - n4;
                } else if (n12 != 0) {
                    n12 = 0x1000000 - n12;
                    n4 = 0xFFFFFF - n4;
                } else if (n4 != 0) {
                    n4 = 0x1000000 - n4;
                }
                if (n7 > 0) {
                    switch (n7) {
                        case 1: {
                            n4 &= 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            n4 &= 0x3FFFFF;
                        }
                    }
                }
            }
            d23 = d24 * TWO_POW_N24;
        } else {
            n4 = (int)(d22 / d24);
            d23 = d24;
        }
        d5 = d23 * (double)n4;
        d6 = (d23 *= TWO_POW_N24) * (double)n12;
        d7 = (d23 *= TWO_POW_N24) * (double)n11;
        d8 = (d23 *= TWO_POW_N24) * (double)n10;
        d9 = (d23 *= TWO_POW_N24) * (double)n9;
        d23 *= TWO_POW_N24;
        d23 = TWOPI_TAB0 * d5;
        d23 += TWOPI_TAB0 * d6 + TWOPI_TAB1 * d5;
        d23 += TWOPI_TAB0 * d7 + TWOPI_TAB1 * d6 + TWOPI_TAB2 * d5;
        d23 += TWOPI_TAB0 * d8 + TWOPI_TAB1 * d7 + TWOPI_TAB2 * d6 + TWOPI_TAB3 * d5;
        return n13 == 0 ? d23 : -(d23 += TWOPI_TAB0 * d9 + TWOPI_TAB1 * d8 + TWOPI_TAB2 * d7 + TWOPI_TAB3 * d6 + TWOPI_TAB4 * d5);
    }

    private static void init() {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n2;
        int n3 = (SIN_COS_TABS_SIZE - 1) / 2;
        int n4 = 2 * n3;
        int n5 = n3 / 2;
        int n6 = 3 * n3 / 2;
        for (n2 = 0; n2 < SIN_COS_TABS_SIZE; ++n2) {
            d6 = (double)n2 * SIN_COS_DELTA_HI + (double)n2 * SIN_COS_DELTA_LO;
            d5 = Math.sin(d6);
            d4 = Math.cos(d6);
            if (n2 == n3) {
                d5 = 0.0;
            } else if (n2 == n4) {
                d5 = 0.0;
            } else if (n2 == n5) {
                d4 = 0.0;
            } else if (n2 == n6) {
                d4 = 0.0;
            }
            JafamaFastMath.sinTab[n2] = d5;
            JafamaFastMath.cosTab[n2] = d4;
        }
        for (n2 = 0; n2 < ASIN_TABS_SIZE; ++n2) {
            d6 = (double)n2 * ASIN_DELTA;
            d5 = 1.0 / (1.0 - d6 * d6);
            d4 = Math.sqrt(d5);
            d3 = d4 * d5;
            d2 = d3 * d5;
            double d7 = d2 * d5;
            JafamaFastMath.asinTab[n2] = Math.asin(d6);
            JafamaFastMath.asinDer1DivF1Tab[n2] = d4;
            JafamaFastMath.asinDer2DivF2Tab[n2] = d6 * d3 * 0.5;
            JafamaFastMath.asinDer3DivF3Tab[n2] = (1.0 + 2.0 * d6 * d6) * d2 * 0.16666666666666666;
            JafamaFastMath.asinDer4DivF4Tab[n2] = (5.0 + 2.0 * d6 * (2.0 + d6 * (5.0 - 2.0 * d6))) * d7 * 0.041666666666666664;
        }
        for (n2 = 0; n2 < ATAN_TABS_SIZE; ++n2) {
            d6 = (double)n2 * ATAN_DELTA;
            d5 = 1.0 / (1.0 + d6 * d6);
            d4 = d5 * d5;
            d3 = d4 * d5;
            d2 = d4 * d4;
            JafamaFastMath.atanTab[n2] = Math.atan(d6);
            JafamaFastMath.atanDer1DivF1Tab[n2] = d5;
            JafamaFastMath.atanDer2DivF2Tab[n2] = -2.0 * d6 * d4 * 0.5;
            JafamaFastMath.atanDer3DivF3Tab[n2] = (-2.0 + 6.0 * d6 * d6) * d3 * 0.16666666666666666;
            JafamaFastMath.atanDer4DivF4Tab[n2] = 24.0 * d6 * (1.0 - d6 * d6) * d2 * 0.041666666666666664;
        }
    }

    static {
        JafamaFastMath.init();
    }
}

