/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractRealDistribution;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.util.CombinatoricsUtils;
import ia.sh.org.apache.commons.math3.util.FastMath;
import ia.sh.org.apache.commons.math3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] EXPONENTIAL_SA_QI;
    private final double mean;
    private final double logMean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistribution(double d2) {
        this(d2, 1.0E-9);
    }

    public ExponentialDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d2) {
        this(randomGenerator, d2, 1.0E-9);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d2);
        }
        this.mean = d2;
        this.logMean = FastMath.log(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    public double getMean() {
        return this.mean;
    }

    public double density(double d2) {
        double d3 = this.logDensity(d2);
        return d3 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d3);
    }

    public double logDensity(double d2) {
        if (d2 < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -d2 / this.mean - this.logMean;
    }

    public double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-d2 / this.mean);
        return d3;
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        double d3 = d2 == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - d2);
        return d3;
    }

    public double sample() {
        double d2;
        double d3;
        double d4 = 0.0;
        for (d3 = this.random.nextDouble(); d3 < 0.5; d3 *= 2.0) {
            d4 += EXPONENTIAL_SA_QI[0];
        }
        if ((d3 += d3 - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return this.mean * (d4 + d3);
        }
        int n2 = 0;
        double d5 = d2 = this.random.nextDouble();
        do {
            ++n2;
            d2 = this.random.nextDouble();
            if (!(d2 < d5)) continue;
            d5 = d2;
        } while (d3 > EXPONENTIAL_SA_QI[n2]);
        return this.mean * (d4 + d5 * EXPONENTIAL_SA_QI[0]);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double d2 = this.getMean();
        return d2 * d2;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    static {
        double d2 = FastMath.log(2.0);
        double d3 = 0.0;
        int n2 = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d3 < 1.0) {
            resizableDoubleArray.addElement(d3 += FastMath.pow(d2, n2) / (double)CombinatoricsUtils.factorial(n2));
            ++n2;
        }
        EXPONENTIAL_SA_QI = resizableDoubleArray.getElements();
    }
}

