/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.addons;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Scanner;
import org.kingdoms.addons.AddonRepository;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.composer.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.utils.config.ConfigSection;

final class AddonFetcher {
    AddonFetcher() {
    }

    static String fetchMetaFile(AddonRepository repo) throws IOException {
        try (Scanner scanner = new Scanner(repo.getMetaFileURL().openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    protected static void fetch(AddonRepository repo) {
        URL url;
        String metaString;
        try {
            metaString = AddonFetcher.fetchMetaFile(repo);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while fetching meta file for addon '" + repo.getName() + "': " + e.getMessage());
        }
        LoadSettings settings = new LoadSettings();
        settings.setLabel(repo.getName());
        Load load2 = new Load(settings);
        Composer composer = load2.createComposer(metaString);
        MappingNode root = composer.getRoot();
        load2.construct(root);
        ConfigSection section = new ConfigSection(null, root);
        ConfigSection repoSection = section.getSection(repo.getPath());
        Objects.requireNonNull(repoSection, () -> "Unable to find repository section for '" + repo.getPath() + "' in meta file: " + metaString);
        String downloadUrl = Objects.requireNonNull(repoSection.getString("url"), () -> "Download URL of addon cannot be null: " + metaString);
        try {
            url = new URL(downloadUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid download URL for addon '" + repo.getName() + "' " + metaString);
        }
        repo.setDownloadURL(url);
        String version = repoSection.getString("version");
        if (Strings.isNullOrEmpty((String)version)) {
            throw new IllegalStateException("No version specified for addon '" + repo.getName() + "' " + metaString);
        }
        repo.setVersion(version);
        repo.setSupportedCoreVersion(repoSection.getString("supported-core-version"));
    }
}

