/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SimpleMessenger;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.string.StringUtils;

public class CommandContext
extends SimpleMessenger {
    public final Kingdoms plugin;
    public final String[] args;
    private final KingdomsCommand command;
    private static final int MAX_ARGS = 5;
    private int argPosition;

    public CommandContext(Kingdoms plugin, KingdomsCommand command, CommandSender sender, String[] args) {
        super(sender, new MessageBuilder().withContext(sender));
        this.settings.lang(this.isPlayer() ? this.getKingdomPlayer().getLanguage() : SupportedLanguage.EN);
        this.plugin = plugin;
        this.command = command;
        this.args = args;
    }

    public String arg(@IntRange(from=0L, to=5L) int index) {
        return this.args[index];
    }

    public boolean argIsAny(@IntRange(from=0L, to=5L) int index, String ... options) {
        String arg = this.arg(index).toLowerCase();
        for (String option : options) {
            if (!arg.equals(option)) continue;
            return true;
        }
        return false;
    }

    public String joinArgs() {
        return this.joinArgs(" ");
    }

    public String joinArgs(String delimiter) {
        return String.join((CharSequence)delimiter, this.args);
    }

    public String joinArgs(@IntRange(from=0L, to=5L) int index) {
        StringBuilder builder = new StringBuilder(30);
        while (index < this.args.length) {
            builder.append(this.args[index++]);
            if (index >= this.args.length) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public KingdomsCommand getCommand() {
        return this.command;
    }

    public Integer parseInt(int index, Messenger argName, boolean allowNegative) {
        String arg = this.arg(index);
        this.settings.raw("arg", argName);
        try {
            int num = Integer.parseInt(arg);
            if (allowNegative) {
                return num;
            }
            if (num < 0) {
                this.sendMessage(this.command.getUsage(), this.settings);
                this.sendError(KingdomsLang.INVALID_NUMBER_NEGATIVE, new Object[0]);
                return null;
            }
            return num;
        }
        catch (NumberFormatException ex) {
            this.sendMessage(this.command.getUsage(), this.settings);
            this.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
            return null;
        }
    }

    public Boolean parseBool(@IntRange(from=0L, to=5L) int index) {
        String str = this.arg(index).toLowerCase(Locale.ENGLISH);
        if (str.equals("true") || KingdomsLang.TRUE.parse(this.sender, new Object[0]).toLowerCase().equals(str)) {
            return true;
        }
        if (str.equals("false") || KingdomsLang.FALSE.parse(this.sender, new Object[0]).toLowerCase().equals(str)) {
            return false;
        }
        this.sendError(KingdomsLang.INVALID_BOOLEAN, "arg", this.arg(index));
        return null;
    }

    public String arg(@IntRange(from=0L, to=5L) int index, String def) {
        return this.assertArgs(index + 1) ? this.args[index] : def;
    }

    public CommandContext debug(String msg) {
        KLogger.info(msg);
        return this;
    }

    public int nextArg() {
        return this.argPosition++;
    }

    public <T extends Group> T generalSelector(boolean targetNation) {
        KingdomPlayer kp;
        Kingdom kingdom;
        OfflinePlayer player;
        Kingdom kingdom2;
        String second;
        String playerTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(this.sender, new Object[0]).toLowerCase();
        String kingdomTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(this.sender, new Object[0]).toLowerCase();
        String nationTag = KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(this.sender, new Object[0]).toLowerCase();
        int from = this.nextArg();
        String identifier = this.args[from].toLowerCase();
        String string = second = this.args.length - 1 < from + 1 ? null : this.args[this.nextArg()];
        if (identifier.equals(playerTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_PLAYERS.parse(SupportedLanguage.EN, new MessageBuilder()).toLowerCase())) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            OfflinePlayer player2 = this.getOfflinePlayer(from + 1);
            if (player2 == null) {
                return null;
            }
            KingdomPlayer kp2 = KingdomPlayer.getKingdomPlayer(player2);
            Kingdom kingdom3 = kp2.getKingdom();
            if (kingdom3 == null) {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM, new Object[0]);
                return null;
            }
            Group group = kingdom3;
            if (targetNation) {
                group = kingdom3.getNation();
            }
            if (group == null) {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_NATION, new Object[0]);
                return null;
            }
            return (T)group;
        }
        if (identifier.equals(kingdomTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_KINGDOMS.parse(SupportedLanguage.EN, new MessageBuilder()).toLowerCase())) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            Kingdom kingdom4 = this.getKingdom(from + 1);
            if (kingdom4 == null) {
                return null;
            }
            Group group = kingdom4;
            if (targetNation) {
                group = kingdom4.getNation();
            }
            if (group == null) {
                this.sendError(KingdomsLang.NO_NATION_OTHER, new Object[0]);
                return null;
            }
            return (T)group;
        }
        if (targetNation && (identifier.equals(nationTag) || identifier.equals(KingdomsLang.COMMANDS_TAGS_IDENTIFIER_NATIONS.parse(SupportedLanguage.EN, new MessageBuilder()).toLowerCase()))) {
            if (second == null) {
                this.wrongUsage();
                return null;
            }
            return (T)this.getNation(from + 1);
        }
        if (second != null) {
            this.wrongUsage();
            return null;
        }
        identifier = this.arg(from);
        Group group = null;
        if (targetNation) {
            group = Nation.getNation(identifier);
        }
        if (group == null && (kingdom2 = Kingdom.getKingdom(identifier)) != null) {
            group = targetNation ? kingdom2.getNation() : kingdom2;
        }
        if (group == null && (player = PlayerUtils.getOfflinePlayer(identifier)) != null && (kingdom = (kp = KingdomPlayer.getKingdomPlayer(player)).getKingdom()) != null) {
            group = targetNation ? kingdom.getNation() : kingdom;
        }
        if (group == null) {
            this.settings.raw("arg", identifier);
            if (targetNation) {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_OR_KINGDOM_OR_NATION, new Object[0]);
            } else {
                this.sendError(KingdomsLang.NOT_FOUND_PLAYER_OR_KINGDOM, new Object[0]);
            }
        }
        return (T)group;
    }

    public CommandResult fail(Messenger lang, Object ... edits) {
        super.sendError(lang, edits);
        return CommandResult.FAILED;
    }

    public void wrongUsage() {
        this.sendError(this.command.getUsage(), new Object[0]);
    }

    public boolean assertPlayer() {
        if (this.isPlayer()) {
            return false;
        }
        KingdomsLang.COMMANDS_PLAYERS_ONLY.sendError(this.sender, new Object[0]);
        return true;
    }

    public Kingdoms getPlugin() {
        return this.plugin;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Player senderAsPlayer() {
        return (Player)this.sender;
    }

    public boolean assertArgs(@IntRange(from=1L, to=5L) int len) {
        return this.args.length >= len;
    }

    public boolean requireArgs(@IntRange(from=1L, to=5L) int len) {
        if (!this.assertArgs(len)) {
            this.wrongUsage();
            return true;
        }
        return false;
    }

    public boolean assertHasKingdom() {
        if (!this.getKingdomPlayer().hasKingdom()) {
            this.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return true;
        }
        return false;
    }

    public Messenger lang(String ... entries) {
        return this.command.lang(entries);
    }

    public boolean argsLengthEquals(int len) {
        return this.args.length == len;
    }

    public boolean isAtArg(@IntRange(from=0L, to=5L) int index) {
        return this.args.length == index + 1;
    }

    public int intArg(@IntRange(from=0L, to=5L) int index) {
        return Integer.parseInt(this.arg(index));
    }

    public boolean isNumber(int index) {
        return StringUtils.isNumeric(this.arg(index));
    }

    public Double getDouble(int index) {
        try {
            return Double.parseDouble(this.arg(index));
        }
        catch (NumberFormatException ignored) {
            this.settings.raw("arg", this.args[1]).raw("needed", "argument");
            this.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
            return null;
        }
    }

    public Integer getInt(int index) {
        try {
            return Integer.parseInt(this.arg(index));
        }
        catch (NumberFormatException ignored) {
            this.settings.raw("arg", this.args[1]).raw("needed", "argument");
            this.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
            return null;
        }
    }

    public KingdomPlayer getKingdomPlayer() {
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.senderAsPlayer());
    }

    public Kingdom getKingdom() {
        return this.getKingdomPlayer().getKingdom();
    }

    public Kingdom getKingdom(int index) {
        Kingdom kingdom = Kingdom.getKingdom(this.arg(index));
        if (kingdom == null) {
            this.settings.raw("kingdom", this.arg(index));
            this.sendError(KingdomsLang.NOT_FOUND_KINGDOM, new Object[0]);
        }
        return kingdom;
    }

    public Nation getNation(int index) {
        Nation nation = Nation.getNation(this.arg(index));
        if (nation == null) {
            this.settings.raw("nation", this.arg(index));
            this.sendError(KingdomsLang.NOT_FOUND_NATION, new Object[0]);
        }
        return nation;
    }

    public boolean argEquals(int index, KingdomsLang lang) {
        return this.argEquals(index, lang.parse(new Object[0]));
    }

    public boolean argEquals(int index, String str) {
        return this.args.length > index && this.arg(index).equals(str);
    }

    @Override
    public CommandSender getSender() {
        return this.sender;
    }

    public boolean hasPermission(KingdomsPluginPermission permission) {
        return this.hasPermission(permission, false);
    }

    public boolean hasPermission(KingdomsPluginPermission permission, boolean checkAdmin) {
        return permission.hasPermission(this.sender, checkAdmin);
    }

    public boolean isAdmin() {
        return !this.isPlayer() || this.getKingdomPlayer().isAdmin();
    }

    public Player getPlayer(int index) {
        return this.getPlayer(index, true);
    }

    public Player getPlayer(int index, boolean exact) {
        String name = this.arg(index);
        Player player = PlayerUtils.getPlayer(name, exact);
        if (player == null) {
            this.settings.raw("name", name);
            this.sendError(KingdomsLang.NOT_FOUND_PLAYER, new Object[0]);
        }
        return player;
    }

    public OfflinePlayer getOfflinePlayer(int index) {
        String name = this.arg(index);
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(name);
        if (player == null) {
            this.settings.raw("name", name);
            this.sendError(KingdomsLang.NOT_FOUND_PLAYER, new Object[0]);
        }
        return player;
    }
}

