/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.admin.CommandAdmin;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.commands.general.claims.CommandClaim;
import org.kingdoms.commands.general.claims.CommandRedo;
import org.kingdoms.commands.general.claims.CommandUnclaim;
import org.kingdoms.commands.general.claims.CommandUndo;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.commands.general.home.CommandHome;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.commands.general.home.CommandUnsetHome;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.commands.general.invitations.CommandDecline;
import org.kingdoms.commands.general.invitations.CommandInvite;
import org.kingdoms.commands.general.invitations.CommandInviteCodes;
import org.kingdoms.commands.general.invitations.CommandInvites;
import org.kingdoms.commands.general.invitations.CommandJoin;
import org.kingdoms.commands.general.invitations.CommandJoinRequests;
import org.kingdoms.commands.general.invitations.CommandRequestJoin;
import org.kingdoms.commands.general.misc.CommandAbout;
import org.kingdoms.commands.general.misc.CommandBank;
import org.kingdoms.commands.general.misc.CommandChallenge;
import org.kingdoms.commands.general.misc.CommandColor;
import org.kingdoms.commands.general.misc.CommandCreate;
import org.kingdoms.commands.general.misc.CommandDisband;
import org.kingdoms.commands.general.misc.CommandDonate;
import org.kingdoms.commands.general.misc.CommandExtractor;
import org.kingdoms.commands.general.misc.CommandFly;
import org.kingdoms.commands.general.misc.CommandGUI;
import org.kingdoms.commands.general.misc.CommandHelp;
import org.kingdoms.commands.general.misc.CommandInvade;
import org.kingdoms.commands.general.misc.CommandInventory;
import org.kingdoms.commands.general.misc.CommandKick;
import org.kingdoms.commands.general.misc.CommandLanguage;
import org.kingdoms.commands.general.misc.CommandLeave;
import org.kingdoms.commands.general.misc.CommandMerge;
import org.kingdoms.commands.general.misc.CommandPvP;
import org.kingdoms.commands.general.misc.CommandRansack;
import org.kingdoms.commands.general.misc.CommandReload;
import org.kingdoms.commands.general.misc.CommandSell;
import org.kingdoms.commands.general.misc.CommandShield;
import org.kingdoms.commands.general.misc.CommandShow;
import org.kingdoms.commands.general.misc.CommandSneak;
import org.kingdoms.commands.general.misc.CommandSurrender;
import org.kingdoms.commands.general.misc.CommandTop;
import org.kingdoms.commands.general.misc.CommandTradable;
import org.kingdoms.commands.general.misc.CommandUpdates;
import org.kingdoms.commands.general.misc.CommandVault;
import org.kingdoms.commands.general.misc.chat.CommandBroadcast;
import org.kingdoms.commands.general.misc.chat.CommandChat;
import org.kingdoms.commands.general.misc.chat.CommandMute;
import org.kingdoms.commands.general.misc.chat.CommandUnmute;
import org.kingdoms.commands.general.misc.mails.CommandMail;
import org.kingdoms.commands.general.misc.map.CommandMap;
import org.kingdoms.commands.general.nexus.CommandNexus;
import org.kingdoms.commands.general.ranking.CommandDemote;
import org.kingdoms.commands.general.ranking.CommandKing;
import org.kingdoms.commands.general.ranking.CommandPromote;
import org.kingdoms.commands.general.relation.CommandAlly;
import org.kingdoms.commands.general.relation.CommandEnemy;
import org.kingdoms.commands.general.relation.CommandRejectRelation;
import org.kingdoms.commands.general.relation.CommandRelations;
import org.kingdoms.commands.general.relation.CommandRevoke;
import org.kingdoms.commands.general.relation.CommandTruce;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePoints;
import org.kingdoms.commands.general.teleports.CommandTeleport;
import org.kingdoms.commands.general.teleports.CommandTpa;
import org.kingdoms.commands.general.teleports.CommandTpaAccept;
import org.kingdoms.commands.general.teleports.CommandTpaReject;
import org.kingdoms.commands.general.text.CommandLore;
import org.kingdoms.commands.general.text.CommandRename;
import org.kingdoms.commands.general.text.CommandTag;
import org.kingdoms.commands.general.visualizer.CommandVisualize;
import org.kingdoms.commands.nation.CommandNation;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.ProxyBytecodeManipulator;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.time.TimeFormatter;

public final class KingdomsCommandHandler
implements CommandExecutor {
    protected static Map<SupportedLanguage, Map<String, KingdomsCommand>> COMMANDS;
    private static final Cooldown<UUID> COOLDOWN;
    private static CommandHelp HELP_COMMAND;
    private final Kingdoms plugin;

    public KingdomsCommandHandler(Kingdoms plugin) {
        this.plugin = plugin;
        PluginCommand command = ProxyBytecodeManipulator.registerCommand((Plugin)plugin, KingdomsConfig.COMMAND_NAME.getManager().getString(), KingdomsConfig.COMMAND_ALIASES.getManager().getStringList());
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)new TabCompleteManager(plugin));
        KingdomsCommandHandler.registerCommands();
    }

    private static void unregisterPermissions(Collection<KingdomsCommand> commands) {
        for (KingdomsCommand cmd : commands) {
            cmd.unregisterPermissions();
            if (!(cmd instanceof KingdomsParentCommand)) continue;
            KingdomsCommandHandler.unregisterPermissions(((KingdomsParentCommand)cmd).getChildren(SupportedLanguage.EN));
        }
    }

    private static void initializeCommandsMap() {
        COMMANDS = new QuickEnumMap((Enum[])SupportedLanguage.VALUES);
    }

    public static void reload() {
        KingdomsCommandHandler.unregisterPermissions(KingdomsCommandHandler.getCommands(SupportedLanguage.EN).values());
        KingdomsCommandHandler.initializeCommandsMap();
        KingdomsCommandHandler.registerCommands();
    }

    public static void registerCommands() {
        HELP_COMMAND = new CommandHelp();
        new CommandAbout();
        new CommandUpdates();
        new CommandReload();
        new CommandCreate();
        new CommandRename();
        new CommandTag();
        new CommandLore();
        new CommandDisband();
        new CommandExtractor();
        new CommandGUI();
        new CommandColor();
        new CommandTpa();
        new CommandTpaAccept();
        new CommandTpaReject();
        new CommandShow();
        new CommandMap();
        new CommandInvade();
        new CommandRansack();
        new CommandChallenge();
        new CommandTeleport();
        new CommandSurrender();
        new CommandLeave();
        new CommandKick();
        new CommandVault();
        new CommandPromote();
        new CommandDemote();
        new CommandKing();
        new CommandChat();
        new CommandMute();
        new CommandUnmute();
        new CommandBroadcast();
        new CommandMail();
        new CommandHome();
        new CommandSetHome();
        new CommandUnsetHome();
        new CommandNexus();
        new CommandDonate();
        new CommandPvP();
        new CommandLanguage();
        new CommandRelations();
        new CommandRevoke();
        new CommandAlly();
        new CommandEnemy();
        new CommandTruce();
        new CommandRejectRelation();
        new CommandResourcePoints();
        new CommandBank();
        new CommandTradable();
        new CommandSell();
        new CommandClaim();
        new CommandUnclaim();
        new CommandRedo();
        new CommandUndo();
        new CommandVisualize();
        new CommandInvite();
        new CommandInvites();
        new CommandInviteCodes();
        new CommandAccept();
        new CommandDecline();
        new CommandJoin();
        new CommandRequestJoin();
        new CommandJoinRequests();
        new CommandFly();
        new CommandSneak();
        new CommandTop();
        new CommandBook();
        new CommandShield();
        new CommandInventory();
        new CommandElection();
        new CommandMerge();
        new CommandNation();
        CommandAdmin.setInstance(new CommandAdmin());
        KingdomsCommandHandler.gatherPermissions();
    }

    private static void gatherPermissions() {
        ArrayList<Permission> permissions = new ArrayList<Permission>(50);
        for (KingdomsCommand value : KingdomsCommandHandler.getCommands(SupportedLanguage.EN).values()) {
            permissions.add(value.getPermission());
        }
        for (KingdomsPluginPermission value : KingdomsPluginPermission.values()) {
            permissions.add(value.getPermission());
        }
        ProxyBytecodeManipulator.injectPermissions(Kingdoms.get(), permissions);
    }

    public static Map<SupportedLanguage, Map<String, KingdomsCommand>> getCommands() {
        return Collections.unmodifiableMap(COMMANDS);
    }

    public static Map<String, KingdomsCommand> getCommands(SupportedLanguage locale) {
        return Objects.requireNonNull(COMMANDS.get((Object)locale), () -> "No commands exist for language: " + (Object)((Object)locale));
    }

    public static CommandInformation getCommand(SupportedLanguage lang, String[] args) {
        KingdomsParentCommand last = null;
        int index = 0;
        for (String arg : args) {
            KingdomsCommand current;
            String lowerArg = arg.toLowerCase(lang.getLocale());
            KingdomsCommand kingdomsCommand = current = last == null ? KingdomsCommandHandler.getCommands(lang).get(lowerArg) : last.children.get((Object)lang).get(lowerArg);
            if (current == null) {
                return new CommandInformation(last, last == null ? index - 1 : index);
            }
            ++index;
            if (!(current instanceof KingdomsParentCommand)) {
                return new CommandInformation(current, index);
            }
            last = (KingdomsParentCommand)current;
        }
        return new CommandInformation(last, index);
    }

    public boolean onCommand(@NonNull CommandSender sender, @NonNull Command cmd, @NonNull String label, @NonNull String[] args) {
        String[] newArgs;
        CommandContext ctx;
        CommandResult res;
        if (args.length == 0) {
            HELP_COMMAND.execute(new CommandContext(this.plugin, HELP_COMMAND, sender, args));
            if (sender instanceof Player) {
                XSound.ITEM_BOOK_PAGE_TURN.play((Entity)((Player)sender));
            }
            return true;
        }
        SupportedLanguage lang = LanguageManager.localeOf(sender);
        CommandInformation info = KingdomsCommandHandler.getCommand(lang, args);
        KingdomsCommand command = info.command;
        if (command == null) {
            KingdomsLang.COMMANDS_UNKNOWN_COMMAND.sendError(sender, "cmd", String.join((CharSequence)" ", args));
            return false;
        }
        if (sender instanceof Player) {
            long cooldown;
            Player player = (Player)sender;
            if (!info.hasPermission(sender)) {
                KingdomsLang.COMMANDS_INSUFFICIENT_PERMISSION.sendError(sender, new Object[0]);
                return false;
            }
            if (!command.getDisabledWorlds().isEmpty() && command.getDisabledWorlds().contains(player.getWorld().getName()) && !command.canBypassDisabledWorlds((CommandSender)player)) {
                KingdomsLang.COMMANDS_DISABLED_WORLD.sendError(sender, "cmd", command.getDisplayName(), "world", player.getWorld().getName());
                return false;
            }
            if (command.getCooldown() > 0L && (cooldown = COOLDOWN.getTimeLeft(player.getUniqueId())) > 0L && !command.canBypassCooldown((CommandSender)player)) {
                KingdomsLang.COMMANDS_COOLDOWN.sendError(sender, "cmd", command.getDisplayName(), "cooldown", TimeFormatter.of(cooldown));
                return false;
            }
        }
        if ((res = command.executeX(ctx = new CommandContext(this.plugin, command, sender, newArgs = info.getCommandArguments(args)))) == CommandResult.NOT_IMPLEMENTED) {
            command.execute(ctx);
            res = CommandResult.SUCCESS;
        }
        if (res == CommandResult.SUCCESS && sender instanceof Player) {
            COOLDOWN.add(((Player)sender).getUniqueId(), command.getCooldown());
        }
        return res == CommandResult.SUCCESS;
    }

    static {
        COOLDOWN = new Cooldown();
        KingdomsCommandHandler.initializeCommandsMap();
    }

    public static final class CommandInformation {
        public final KingdomsCommand command;
        protected final int cmdIndex;

        public CommandInformation(KingdomsCommand command, int cmdIndex) {
            this.command = command;
            this.cmdIndex = cmdIndex;
        }

        public String[] getCommandArguments(String[] args) {
            String[] cmdArgs = new String[args.length - this.cmdIndex];
            System.arraycopy(args, this.cmdIndex, cmdArgs, 0, cmdArgs.length);
            return cmdArgs;
        }

        public boolean hasPermission(CommandSender sender) {
            return !(sender instanceof Player) || this.command.hasPermission(sender) || KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
        }
    }
}

