/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.internal.identity.QuantumIdentityHashMap;
import org.kingdoms.utils.string.QuantumString;
import org.kingdoms.utils.string.StringUtils;

public final class TabCompleteManager
implements TabCompleter {
    private final Kingdoms plugin;

    public TabCompleteManager(Kingdoms plugin) {
        this.plugin = plugin;
    }

    private static @NonNull List<String> getMainSuggestions(CommandSender sender, @Nullable String starts) {
        return new SmartCompleter(KingdomsCommandHandler.getCommands(LanguageManager.localeOf(sender)).values(), sender, starts).process();
    }

    public static @NonNull List<String> getSubCommand(@NonNull CommandSender sender, @NonNull KingdomsParentCommand command, @NonNull String[] args) {
        if (args.length == 0) {
            return new ArrayList<String>();
        }
        String starts = args[0];
        return new SmartCompleter(command.getChildren(LanguageManager.localeOf(sender)), sender, starts).process();
    }

    public static @NonNull List<String> getPlayers(@NonNull String starts) {
        return TabCompleteManager.getPlayers(starts, null);
    }

    public static @NonNull List<String> getPlayers(@NonNull String starts, boolean admin) {
        return TabCompleteManager.getPlayers(starts, null);
    }

    public static @NonNull List<String> getPlayers(@NonNull String starts, Predicate<OfflinePlayer> filter) {
        return TabCompleteManager.getPlayers(Bukkit.getOnlinePlayers(), starts, false, filter);
    }

    public static @NonNull List<String> getPlayers(Collection<? extends OfflinePlayer> players, @NonNull String starts, boolean admin, Predicate<OfflinePlayer> filter) {
        ArrayList<String> names = new ArrayList<String>(players.size());
        boolean empty = starts.isEmpty();
        if (!empty) {
            starts = starts.toLowerCase(Locale.ENGLISH);
        }
        for (OfflinePlayer offlinePlayer : players) {
            if (!admin && offlinePlayer instanceof Player && ServiceHandler.isVanished((Player)offlinePlayer)) continue;
            String name = PlayerUtils.validateOfflineName(offlinePlayer);
            if (!empty && !StringUtils.toLatinLowerCase(name).startsWith(starts) || filter != null && !filter.test(offlinePlayer)) continue;
            names.add(name);
        }
        return names;
    }

    public static @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, @NonNull String starts) {
        return TabCompleteManager.getPlayers(kingdom.getPlayerMembers(), starts, true, null);
    }

    public static @NonNull List<String> getKingdomPlayers(@NonNull Kingdom kingdom, @NonNull String starts, Predicate<OfflinePlayer> filter) {
        return TabCompleteManager.getPlayers(kingdom.getPlayerMembers(), starts, true, filter);
    }

    public static @NonNull List<String> getKingdoms(@Nullable String starts) {
        return TabCompleteManager.getKingdoms(starts, null);
    }

    public static @NonNull List<String> getKingdomMembers(@NonNull Nation nation, @Nullable String starts, @Nullable Predicate<Kingdom> predicate) {
        List<Kingdom> kingdoms = nation.getKingdoms();
        ArrayList<String> names = new ArrayList<String>(kingdoms.size());
        boolean empty = starts.isEmpty();
        for (Kingdom kingdom : kingdoms) {
            String name = kingdom.getName();
            if (!empty && !name.toLowerCase(Locale.ENGLISH).startsWith(starts) || predicate != null && !predicate.test(kingdom)) continue;
            names.add(name);
        }
        return names;
    }

    private static @NonNull List<String> getGroups(@NonNull Map<QuantumString, UUID> names, @Nullable QuantumString starts, @Nullable Predicate<String> predicate) {
        ArrayList<String> groups = new ArrayList<String>(Math.max(names.size() / Math.max(1, starts.length()), 30));
        String startsqBit = starts.getQuantum();
        for (QuantumString name : names.keySet()) {
            String quantum = name.getQuantum();
            if (predicate != null && !predicate.test(quantum)) continue;
            if (starts.isEmpty()) {
                groups.add(quantum);
                continue;
            }
            if (!name.getQuantum().startsWith(startsqBit)) continue;
            groups.add(quantum);
        }
        return groups;
    }

    public static @NonNull List<String> getKingdoms(@Nullable String starts, @Nullable Predicate<String> predicate) {
        return TabCompleteManager.getGroups(KingdomManager.getNames(), KingdomManager.toQuantumName(starts), predicate);
    }

    public static @NonNull List<String> getNations(@Nullable String starts) {
        return TabCompleteManager.getNations(starts, null);
    }

    public static @NonNull List<String> getNations(@Nullable String starts, @Nullable Predicate<String> predicate) {
        return TabCompleteManager.getGroups(NationManager.getNames(), NationManager.toQuantumName(starts), predicate);
    }

    public @NonNull List<String> onTabComplete(@NonNull CommandSender sender, @NonNull Command cmd, @NonNull String label, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getMainSuggestions(sender, args[0]);
        }
        KingdomsCommandHandler.CommandInformation info = KingdomsCommandHandler.getCommand(LanguageManager.localeOf(sender), args);
        KingdomsCommand command = info.command;
        if (command == null) {
            return new ArrayList<String>();
        }
        if (!info.hasPermission(sender)) {
            return new ArrayList<String>();
        }
        String[] commandArguments = info.getCommandArguments(args);
        if (command instanceof KingdomsParentCommand && args.length == info.cmdIndex) {
            return TabCompleteManager.getSubCommand(sender, (KingdomsParentCommand)command, commandArguments);
        }
        List<String> result = command.tabComplete(sender, commandArguments);
        if (result != null) {
            return result;
        }
        return command.tabComplete(new CommandTabContext(this.plugin, command, sender, commandArguments));
    }

    private static final class SmartCompleter {
        private final Collection<KingdomsCommand> source;
        private final List<String> commands = new ArrayList<String>(10);
        private final Set<KingdomsCommand> addedCommands = Collections.newSetFromMap(new QuantumIdentityHashMap());
        private final CommandSender sender;
        private final @Nullable String input;
        private final boolean isAdmin;
        private final SupportedLanguage locale;

        private SmartCompleter(Collection<KingdomsCommand> source, CommandSender sender, @Nullable String input) {
            this.source = source;
            this.sender = sender;
            this.isAdmin = !(sender instanceof Player) || KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
            this.locale = LanguageManager.localeOf(sender);
            this.input = input.toLowerCase(this.locale.getLocale());
        }

        public List<String> process() {
            this.addSuggestionLevel(false, false);
            if (this.commands.size() <= 5) {
                this.addSuggestionLevel(false, true);
            }
            if (this.commands.size() <= 10) {
                this.addSuggestionLevel(true, false);
            }
            if (this.commands.size() <= 15) {
                this.addSuggestionLevel(true, true);
            }
            return this.commands;
        }

        private void addSuggestion(KingdomsCommand cmd, String name) {
            if (this.addedCommands.add(cmd)) {
                this.commands.add(name);
            }
        }

        private void addSuggestionLevel(boolean alias, boolean contains) {
            for (KingdomsCommand cmd : this.source) {
                List<String> commands;
                if (!this.isAdmin && !cmd.hasPermission(this.sender)) continue;
                if (alias) {
                    commands = cmd.aliases.get((Object)this.locale);
                    if (commands.isEmpty()) {
                        continue;
                    }
                } else {
                    commands = Collections.singletonList(cmd.getDisplayName().getMessageObject(this.locale).buildPlain(MessageBuilder.DEFAULT));
                }
                for (String name : commands) {
                    String lowerName = name.toLowerCase(this.locale.getLocale());
                    if (contains) {
                        if (!lowerName.contains(this.input)) continue;
                        this.addSuggestion(cmd, name);
                        continue;
                    }
                    if (!lowerName.startsWith(this.input)) continue;
                    this.addSuggestion(cmd, name);
                }
            }
        }
    }
}

