/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LocationLocale;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminLand
extends KingdomsCommand {
    public CommandAdminLand(KingdomsParentCommand parent) {
        super("land", parent);
    }

    @Override
    public void execute(CommandContext context) {
        int z;
        int x;
        World world;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(2)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        Player player = context.senderAsPlayer();
        int coordIndex = 0;
        if (args.length > 2) {
            world = Bukkit.getWorld((String)args[0]);
            if (world == null) {
                KingdomsLang.COMMAND_ADMIN_LAND_INVALID_WORLD.sendMessage((CommandSender)player, "world", args[0]);
                return;
            }
            coordIndex = 1;
        } else {
            world = player.getWorld();
        }
        try {
            x = Integer.parseInt(args[coordIndex]);
            z = Integer.parseInt(args[coordIndex + 1]);
        }
        catch (NumberFormatException ex) {
            KingdomsLang.COMMAND_ADMIN_LAND_INVALID_COORDINATES.sendMessage((CommandSender)player, "world", world.getName(), "x", args[coordIndex], "z", args[coordIndex + 1]);
            return;
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_LAND_PREPARING, new Object[0]);
        SimpleChunkLocation chunk = new SimpleChunkLocation(world.getName(), x, z);
        PaperUtils.prepareChunks(chunk).thenRun(() -> {
            Location playerDir = player.getLocation();
            Location location = chunk.getCenterLocation();
            location.setYaw(playerDir.getYaw());
            location.setPitch(playerDir.getPitch());
            Kingdoms.taskScheduler().sync().execute(() -> player.teleport(location));
            LocationLocale.of(location).withBuilder(context.getSettings()).build();
            LocationLocale.of(chunk).withBuilder(context.getSettings()).withPrefix("chunk_").build();
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_LAND_TELEPORTED, new Object[0]);
        });
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            if (StringUtils.isNumeric(args[0])) {
                return Collections.singletonList("<x>");
            }
            List<String> worlds = Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(w -> w.startsWith(args[0])).collect(Collectors.toList());
            worlds.add(MessageHandler.colorize("&5<x>"));
            return worlds;
        }
        if (args.length == 2) {
            if (StringUtils.isNumeric(args[0])) {
                return Collections.singletonList(MessageHandler.colorize("&5<z>"));
            }
            return Collections.singletonList(MessageHandler.colorize("&5<x>"));
        }
        if (args.length == 3 && !StringUtils.isNumeric(args[0])) {
            return Collections.singletonList(MessageHandler.colorize("&5<z>"));
        }
        return new ArrayList<String>();
    }
}

