/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.CommandAdminOpenFile;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.tree.StringPathBuilder;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminMissingGUIs;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
public final class CommandAdminMissingGUIs
extends KingdomsCommand {
    public CommandAdminMissingGUIs(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("missingGUIs", parent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object lang2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path output = Kingdoms.getFolder().resolve("Missing GUIs.txt");
        context.var("output", output);
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        context.var("sanitized_output", CommandAdminOpenFile.Companion.sanitize(output));
        ArrayList<String> files = new ArrayList<String>();
        List<SupportedLanguage> installed = SupportedLanguage.getInstalled();
        if (installed.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_MISSINGGUIS_NO_LANGUAGE_PACKS_INSTALLED, new Object[0]);
            return CommandResult.FAILED;
        }
        for (Object lang2 : installed) {
            if (lang2 == SupportedLanguage.EN) continue;
            for (String gui : SupportedLanguage.EN.getGUIs().keySet()) {
                boolean exists = lang2.getGUI(gui) != null;
                if (exists) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string = lang2.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                files.add(stringBuilder.append(string).append(" (").append(lang2.getNativeName()).append(")/").append(gui).toString());
            }
        }
        Object $this$executeX_u24lambda_u2d0 = lang2 = new TreeStyle(StringTree.Companion.getUTF_CHARACTER_SET(), MapsKt.emptyMap());
        boolean bl = false;
        ((TreeStyle)$this$executeX_u24lambda_u2d0).setFlatten(true);
        ((TreeStyle)$this$executeX_u24lambda_u2d0).setIndentation(2);
        SupportedLanguage style = lang2;
        StringTree pathBuilder = new StringPathBuilder((List<String>)files).toStringTree((TreeStyle)((Object)style)).print();
        $this$executeX_u24lambda_u2d0 = pathBuilder.getLines();
        Path path = output;
        boolean $i$f$map = false;
        void exists = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(x.toString());
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
        Files.write(path, (Iterable<? extends CharSequence>)((List)destination$iv$iv), openOptionArray);
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_MISSINGGUIS_DONE, new Object[0]);
        return CommandResult.SUCCESS;
    }
}

