/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.SetterHandler;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminResourcePoints
extends KingdomsCommand {
    public CommandAdminResourcePoints(KingdomsParentCommand parent) {
        super("resourcepoints", parent);
    }

    @Override
    public void execute(CommandContext context) {
        String number;
        String action;
        int index;
        Kingdom kingdom;
        if (context.requireArgs(2)) {
            return;
        }
        CommandSender sender = context.getSender();
        if (context.arg(0).equals("#PLAYER")) {
            Player player = context.getPlayer(1);
            if (player == null) {
                return;
            }
            kingdom = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getKingdom();
            if (kingdom == null) {
                KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_PLAYER_NO_KINGDOM.sendMessage(sender);
                return;
            }
            index = 2;
        } else {
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return;
            }
            index = 1;
        }
        if (context.assertArgs(index + 2)) {
            action = context.arg(index);
            number = context.arg(index + 1);
        } else {
            action = "add";
            number = context.arg(index);
        }
        SetterHandler.SetterResult result = SetterHandler.eval(action, (double)kingdom.getResourcePoints(), number);
        if (result == SetterHandler.SetterResult.NOT_NUMBER) {
            KingdomsLang.INVALID_NUMBER.sendMessage(sender, "arg", number);
            return;
        }
        if (result == SetterHandler.SetterResult.UNKNOWN) {
            KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_INVALID_ACTION.sendMessage(sender, "action", action);
            return;
        }
        kingdom.setResourcePoints(Math.max(0L, (long)result.getValue()));
        KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_DONE.sendMessage(sender, "kingdom", kingdom.getName(), "rp", StringUtils.toFancyNumber(kingdom.getResourcePoints()));
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_ADDED.sendMessage((CommandSender)member, "rp", StringUtils.toFancyNumber(kingdom.getResourcePoints()));
        }
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            List<String> kingdoms = TabCompleteManager.getKingdoms(args[0]);
            kingdoms.add("#PLAYER");
            return kingdoms;
        }
        if (args.length == 2) {
            if (args[0].equals("#PLAYER")) {
                return TabCompleteManager.getPlayers(args[1]);
            }
            return SetterHandler.tabComplete(args[1]);
        }
        if (args.length == 3) {
            if (args[0].equals("#PLAYER")) {
                return SetterHandler.tabComplete(args[2]);
            }
            return Collections.singletonList("<amount>");
        }
        if (args.length == 4 && args[0].equals("#PLAYER")) {
            return Collections.singletonList("<amount>");
        }
        return new ArrayList<String>();
    }
}

