/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.claim;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.CommandUnclaimAll;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminUnclaimAll
extends KingdomsCommand {
    public CommandAdminUnclaimAll(KingdomsParentCommand parent) {
        super("all", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        int unclaimed = CommandUnclaimAll.unclaimAll(context.getKingdomPlayer(), UnclaimLandEvent.Reason.ADMIN, kingdom);
        context.var("lands", unclaimed);
        context.sendMessage(KingdomsLang.COMMAND_UNCLAIM_ALL_SUCCESS, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        return CommandAdminUnclaimAll.emptyTab();
    }
}

