/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.time.TimeFormatter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/debugging/CommandAdminEntity;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "Companion", "core"})
public final class CommandAdminEntity
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandAdminEntity(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("entity", parent);
    }

    @Override
    public void execute(@NotNull CommandContext context) {
        boolean showDetails;
        double d;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertArgs(1)) {
            Double d2 = context.getDouble(0);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"context.getDouble(0)");
            d = ((Number)d2).doubleValue();
        } else {
            d = 10.0;
        }
        double radius = d;
        Integer stay = context.assertArgs(2) ? context.getInt(1) : Integer.valueOf(1);
        boolean bl = showDetails = context.assertArgs(3) && StringsKt.equals((String)context.arg(2), (String)"true", (boolean)true);
        if (radius <= 1.0) {
            MessageHandler.sendPluginMessage(context.getSender(), "&cNegative radius&8: &e" + radius);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)stay, (String)"stay");
        if (stay <= 0) {
            MessageHandler.sendPluginMessage(context.getSender(), "&cNegative stay number&8: &e" + stay);
            return;
        }
        AtomicInteger total = new AtomicInteger();
        Player player = context.senderAsPlayer();
        new BukkitRunnable(stay, player, radius, showDetails, total){
            private Integer times;
            private boolean looping;
            final /* synthetic */ Player $player;
            final /* synthetic */ double $radius;
            final /* synthetic */ boolean $showDetails;
            final /* synthetic */ AtomicInteger $total;
            {
                this.$player = $player;
                this.$radius = $radius;
                this.$showDetails = $showDetails;
                this.$total = $total;
                this.times = $stay;
            }

            public final Integer getTimes() {
                return this.times;
            }

            public final void setTimes(Integer n) {
                this.times = n;
            }

            public final boolean getLooping() {
                return this.looping;
            }

            public final void setLooping(boolean bl) {
                this.looping = bl;
            }

            public void run() {
                for (Entity entity : this.$player.getNearbyEntities(this.$radius, this.$radius, this.$radius)) {
                    if (!this.looping) {
                        String string;
                        Location loc;
                        Intrinsics.checkNotNullExpressionValue((Object)entity.getLocation(), (String)"entity.location");
                        CommandSender commandSender = (CommandSender)this.$player;
                        StringBuilder stringBuilder = new StringBuilder().append("&8\u26ab &2").append(entity.getType()).append(" (").append(entity.getCustomName()).append("&2) &6hover:{").append(LocationUtils.toReadableLoc(loc)).append(";&9Click to teleport;/minecraft:tp ").append(loc.getX()).append(' ').append(loc.getY()).append(' ').append(loc.getZ()).append('}');
                        if (this.$showDetails) {
                            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                            string = CommandAdminEntity.Companion.details(entity);
                        } else {
                            string = "";
                        }
                        MessageHandler.sendMessage(commandSender, stringBuilder.append(string).toString());
                    }
                    ParticleDisplay.of(Particle.FLAME).withLocation(entity.getLocation()).withCount(20).offset(0.3).spawn();
                    XParticle.line(this.$player.getLocation(), entity.getLocation(), 0.5, ParticleDisplay.of(Particle.SPELL_WITCH));
                    if (this.looping) continue;
                    this.$total.incrementAndGet();
                }
                if (!this.looping) {
                    this.looping = true;
                    MessageHandler.sendPluginMessage((CommandSender)this.$player, "&2Found a total of &6" + this.$total + " &2entities within &6" + this.$radius + " &2block radius.");
                }
                Integer n = this.times = Integer.valueOf(this.times + -1);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"--times");
                if (((Number)n).intValue() <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)KingdomsCommand.plugin, 0L, 5L);
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        List<String> list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            List<String> list3 = KingdomsCommand.tabComplete("[radius]");
            Intrinsics.checkNotNullExpressionValue(list3, (String)"tabComplete(\"[radius]\")");
            return list3;
        }
        if (context.isAtArg(1)) {
            List<String> list4 = KingdomsCommand.tabComplete("[stay]");
            Intrinsics.checkNotNullExpressionValue(list4, (String)"tabComplete(\"[stay]\")");
            return list4;
        }
        if (context.isAtArg(2)) {
            List<String> list5 = KingdomsCommand.tabComplete("[show details?]");
            list2 = list5;
            Intrinsics.checkNotNullExpressionValue(list5, (String)"tabComplete(\"[show details?]\")");
        } else {
            List<String> list6 = KingdomsCommand.emptyTab();
            list2 = list6;
            Intrinsics.checkNotNullExpressionValue(list6, (String)"emptyTab()");
        }
        return list2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/commands/admin/debugging/CommandAdminEntity$Companion;", "", "()V", "details", "", "entity", "Lorg/bukkit/entity/Entity;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String details(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            List details = new ArrayList();
            List flags = new ArrayList();
            if (entity.isFrozen()) {
                flags.add("Frozen");
            }
            if (entity.isInvulnerable()) {
                flags.add("Invulnerable");
            }
            if (entity.isSilent()) {
                flags.add("Silent");
            }
            if (entity instanceof LivingEntity) {
                Entity zom;
                Pair<String, Integer> pair = Pair.of("No Damage Ticks", ((LivingEntity)entity).getNoDamageTicks());
                Intrinsics.checkNotNullExpressionValue(pair, (String)"of(\"No Damage Ticks\", entity.noDamageTicks)");
                details.add(pair);
                if (((LivingEntity)entity).isCollidable()) {
                    flags.add("Collidable");
                }
                if (((LivingEntity)entity).isInvisible()) {
                    flags.add("Invisible");
                }
                if (ReflectionUtils.supports(13) && entity instanceof Zombie && ((Zombie)(zom = entity)).isConverting()) {
                    Pair<String, MessageObjectBuilder> pair2 = Pair.of("Convertion Time", TimeFormatter.of(((Zombie)zom).getConversionTime()));
                    Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"of(\n                    \u2026                        )");
                    details.add(pair2);
                }
            }
            StringBuilder detailsStr = new StringBuilder();
            if (!((Collection)flags).isEmpty()) {
                detailsStr.append("\n   &8| &9");
                detailsStr.append(String.join((CharSequence)"&7, &9", flags));
            }
            for (Pair pair : details) {
                String key = (String)((Map.Entry)pair).getKey();
                Object value = ((Map.Entry)pair).getValue();
                if (value instanceof Number && ((Number)value).doubleValue() == 0.0) continue;
                detailsStr.append("\n   &8| &2").append(key).append("&7: &9").append(value);
            }
            String string = detailsStr.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"detailsStr.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

