/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;

public class CommandAdminExecute
extends KingdomsCommand {
    public CommandAdminExecute(KingdomsParentCommand parent) {
        super("execute", parent);
    }

    @Override
    public void execute(CommandContext context) {
        int mainIndex;
        String mainCmd;
        PluginCommand cmd;
        String command;
        if (!context.assertArgs(3)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_EXECUTE_USAGE, new Object[0]);
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        Executor executor = (Executor)((Object)Enums.getIfPresent(Executor.class, (String)context.arg(1).toUpperCase(Locale.ENGLISH)).orNull());
        if (executor == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_EXECUTE_UNKNOWN_EXECUTOR, "executor", context.arg(1));
            return;
        }
        Boolean filter = null;
        String thirdArg = context.arg(2);
        if (thirdArg.charAt(0) != '/') {
            if ((thirdArg = thirdArg.toLowerCase(Locale.ENGLISH)).equals("online")) {
                filter = true;
            } else if (thirdArg.equals("offline")) {
                filter = false;
                if (executor == Executor.MEMBERS) {
                    context.sendError(KingdomsLang.COMMAND_ADMIN_EXECUTE_MEMBERS_OFFLINE, "filter", context.arg(2));
                    return;
                }
            } else {
                context.sendError(KingdomsLang.COMMAND_ADMIN_EXECUTE_UNKNOWN_FILTER, "filter", context.arg(2));
                return;
            }
            command = context.joinArgs(3);
        } else {
            command = context.joinArgs(2);
        }
        if (executor == Executor.MEMBERS && filter == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_EXECUTE_MEMBERS_NO_FILTER, "filter", context.arg(2));
            return;
        }
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        if ((cmd = Bukkit.getPluginCommand((String)(mainCmd = command.substring(0, (mainIndex = command.indexOf(32)) < 0 ? command.length() : mainIndex)))) == null) {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_EXECUTE_UNKNOWN_COMMAND, "command", mainCmd, "kingdom", kingdom.getName());
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_EXECUTE_EXECUTED, "command", cmd == null ? "~" : cmd.getName(), "plugin", cmd == null ? " server" : cmd.getPlugin().getName(), "kingdom", kingdom.getName());
        for (OfflinePlayer member : kingdom.getPlayerMembers()) {
            CommandSender currentExecutor;
            if (filter != null && filter.booleanValue() != member.isOnline()) continue;
            switch (executor) {
                case SELF: {
                    currentExecutor = context.getSender();
                    break;
                }
                case MEMBERS: {
                    currentExecutor = member.getPlayer();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Bukkit.dispatchCommand((CommandSender)currentExecutor, (String)MessageCompiler.compile(command).buildPlain(new MessageBuilder().withContext(member.getPlayer())));
        }
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        if (context.isAtArg(1)) {
            return CommandAdminExecute.tabComplete("self", "members");
        }
        if (context.isAtArg(2)) {
            if (context.arg(1).equalsIgnoreCase("members")) {
                return CommandAdminExecute.tabComplete("online");
            }
            return CommandAdminExecute.tabComplete("online", "offline");
        }
        if (context.isAtArg(3) && context.argIsAny(2, "online", "offline")) {
            return CommandAdminExecute.tabComplete("<command>");
        }
        if (context.assertArgs(4)) {
            String command;
            int mainIndex = (command = context.arg(3)).indexOf(32);
            String mainCmd = command.substring(0, mainIndex < 0 ? command.length() : mainIndex);
            PluginCommand cmd = Bukkit.getPluginCommand((String)mainCmd);
            if (cmd == null) {
                return CommandAdminExecute.emptyTab();
            }
            String[] cmdArgs = Arrays.copyOfRange(context.getArgs(), 3, context.getArgs().length);
            return cmd.tabComplete(context.getSender(), mainCmd, cmdArgs);
        }
        return CommandAdminExecute.emptyTab();
    }

    private static enum Executor {
        SELF,
        MEMBERS;

    }
}

