/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminSound
extends KingdomsCommand {
    public CommandAdminSound(KingdomsParentCommand parent) {
        super("sound", parent);
    }

    @Override
    public void execute(CommandContext context) {
        XSound.Record record;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        try {
            record = XSound.parse(String.join((CharSequence)",", context.args));
        }
        catch (Throwable ex) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_SOUND_ERROR, "error", ex.getMessage());
            return;
        }
        if (record == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_SOUND_ERROR, "error", "No Sound");
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_SOUND_PLAYING, new Object[0]);
        record.forPlayer(context.senderAsPlayer()).play();
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            String sound = StringUtils.replace(context.arg(0).toUpperCase(Locale.ENGLISH), '-', '_').toString();
            Stream<String> stream = Arrays.stream(XSound.VALUES).map(Enum::name);
            if (sound.isEmpty()) {
                return stream.collect(Collectors.toList());
            }
            return stream.filter(x -> x.contains(sound)).collect(Collectors.toList());
        }
        if (context.isAtArg(1)) {
            return CommandAdminSound.tabComplete("&9[volume]");
        }
        if (context.isAtArg(2)) {
            return CommandAdminSound.tabComplete("&6[pitch]");
        }
        return CommandAdminSound.emptyTab();
    }
}

