/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.placeholders.KingdomsPlaceholder;
import org.kingdoms.locale.compiler.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminTest
extends KingdomsCommand {
    public CommandAdminTest(KingdomsParentCommand parent) {
        super("test", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return;
        }
        String message = MessageHandler.replace(context.joinArgs(), "\\n", "\n");
        MessageCompiler compiler = new MessageCompiler(message.toCharArray(), new MessageCompilerSettings(true, false, true, true, true, null));
        MessageObject obj = compiler.compileObject();
        MessageBuilder settings = new MessageBuilder().withContext(context.getSender()).raw("test_int", ThreadLocalRandom.current().nextInt(1, 100)).raw("test_string", StringUtils.random(5, 20, "aldfoasdbnopu2910871054sdfjvnaoghwhserm;sdfo$)@#&*)%^&*!@)#")).raw("test", ThreadLocalRandom.current().nextInt(1, 100));
        context.getSender().sendMessage(MessageCompiler.compile("&2Compiled&8: &f%built%").buildPlain(new MessageBuilder().raw("built", compiler)));
        context.getSender().sendMessage(obj.buildPlain(settings));
        MessageHandler.sendPluginMessage(context.getSender(), "&7---------------- Complex:");
        for (BaseComponent[] components : obj.build(settings).create()) {
            context.getSender().spigot().sendMessage(components);
        }
        if (compiler.hasErrors()) {
            MessageHandler.sendPluginMessage(context.getSender(), "&8==================");
            MessageHandler.sendPluginMessage(context.getSender(), "&4Error(s)&8:");
            context.getSender().sendMessage(compiler.joinExceptions());
        }
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 0) {
            return new ArrayList<String>();
        }
        String last = args[args.length - 1];
        if (last.isEmpty()) {
            return new ArrayList<String>();
        }
        if (last.equals("~")) {
            String[] testArgs = (String[])Arrays.stream(args).limit((long)args.length - 1L).toArray(String[]::new);
            String text = CommandAdminTest.joinArgs(testArgs);
            return CommandAdminTest.tabComplete(text);
        }
        if ("%kingdoms_".startsWith(last)) {
            return KingdomsPlaceholder.NAMES.keySet().stream().map(x -> "%kingdoms_" + x + '%').collect(Collectors.toList());
        }
        if (last.startsWith("%kingdoms_")) {
            return KingdomsPlaceholder.NAMES.keySet().stream().filter(x -> x.startsWith(last.substring(10))).map(x -> "%kingdoms_" + x + '%').collect(Collectors.toList());
        }
        if (last.startsWith("{$")) {
            ArrayList<String> macros = new ArrayList<String>(StandardKingdomsPlaceholder.getGlobalMacros().keySet());
            macros.addAll(LanguageManager.localeOf(sender).getMessages().keySet().stream().filter(k -> k.getPath()[0].equals("variables")).map(k -> k.getPath()[1]).collect(Collectors.toList()));
            return macros.stream().filter(x -> last.equals("{$") || x.toLowerCase(Locale.ENGLISH).contains(last.substring(2).toLowerCase(Locale.ENGLISH))).map(x -> "{$" + x + '}').collect(Collectors.toList());
        }
        if (last.startsWith("{%")) {
            return Collections.singletonList("{%colorBackReferencePlaceholder [& colorIndex]}");
        }
        if ("hover:{".startsWith(last)) {
            return Collections.singletonList("hover:{}");
        }
        if (last.startsWith("hover:{")) {
            return Arrays.asList("message", "hover", "action");
        }
        if ("&#".startsWith(last)) {
            return Collections.singletonList("&#<hex>");
        }
        return new ArrayList<String>();
    }
}

